/* Copyright information can be found in file "Copyright" */

/************************************************************************/
/* afm-2.y                                                              */
/************************************************************************/

%%      /* Rules Section */

program :	Initial CharMetrics Kerning Comp End
;	

Initial :       StartFontStuff InitialStuffs
;

StartFontStuff: K_StartFontMetrics T_FLOAT newlines
;

InitialStuffs:  |
                InitialStuffs InitialStuff
;

InitialStuff :  K_Ascender garbages newlines |
                K_CapHeight garbages newlines |
                Comment |
                K_Descender garbages newlines|
                K_EncodingScheme garbages newlines|
                K_FamilyName garbages newlines|
                K_FontBBox garbages newlines|
                FontName |
                K_FullName garbages newlines |
                K_ItalicAngle garbages newlines|
                IsFixedPitch |
                Notice |
                K_UnderlinePosition garbages newlines|
                K_UnderlineThickness garbages newlines|
                K_Version garbages newlines|
                K_Weight garbages newlines|
                XHeight
;

FontName : K_FontName T_ID newlines
{
  AfmFileBasedFontName = $2;
}

/*
 * This production is for those production which simply ignore their
 * argument, the rest of the line.
 */
garbages :
	|               garbages	garbage
;

garbage :               T_FLOAT |
                        T_ID |
                        T_INT |
                        T_SEMICOLON
;

/* Notice has to be treated the same way */
Comment :                S_Comment
       {        printf ("Comment: \"%s\"\n", $1);
	}	newlines
;

Notice :                S_Notice newlines
       {        printf ("Notice: \"%s\"\n", $1);
	}
;

XHeight:                K_XHeight T_INT newlines
{               XHeight = $2;
}
;

IsFixedPitch :          K_IsFixedPitch T_ID newlines
            {           if (strcmp ($2, "true") == 0)
                            IsFixedPitch = TRUE;
                        else {
                            if (strcmp ($2, "false") == 0)
                                IsFixedPitch = FALSE;
                            else
			        Fatal ("IsFixedPitch specification wrong\n");
			  }
	    }
;

CharMetrics :           StartCharMetrics Characters EndCharMetrics
;

StartCharMetrics :      K_StartCharMetrics T_INT newlines
	|	K_StartCharMetrics newlines
;

Characters :            Character |
                        Characters Character
;

/*
 * This is where we read in the data about each character
 */
Character :             K_C              /* field 1 in .afm file */
                        T_INT            /* field 2: character code */
                        T_SEMICOLON      /* field 3 */
                        T_ID             /* field 4, must be "WX" */
                        T_INT            /* field 5: the width */
                        T_SEMICOLON      /* field 6 */
                        T_ID             /* field 7: must be "N" */
                        T_ID             /* field 8: the name of the char.*/
                        T_SEMICOLON      /* field 9 */
                        T_ID             /* field 10: must be "B" */
                        T_INT            /* field 11: llx */
                        T_INT            /* field 12: lly */
                        T_INT            /* field 13: urx */
                        T_INT            /* field 14: ury */
                        T_SEMICOLON      /* field 15 */
         { CompareStringError ($4, "WX", "reading .afm file");
	   CompareStringError ($7, "N",  "reading .afm file");
	   CompareStringError ($10,"B",  "reading .afm file");
	   AfmCharDo($2, $8, $5, $11, $12, $13, $14);
	 }
                        Character_Ligs
                        newlines
;

Character_Ligs:          |
                        Character_Ligs Character_Lig
;

Character_Lig:
                        T_ID T_ID T_ID T_SEMICOLON
          {             CompareStringError ($1, "L",
					    "Ligature reading in .afm file");
			if (UseAfmLigatures)
			  SaveLigatureInfo (AfmCharacterName, $2, $3);
          }
;

EndCharMetrics :        K_EndCharMetrics newlines
;

/*
 * Fixed space fonts have no kerning info, therefore it is optional
 */
Kerning :               |
                        K_StartKernData newlines
                        KernPairs
                        K_EndKernData newlines
;

KernPairs :             K_StartKernPairs T_INT newlines
                        KPXs K_EndKernPairs newlines
;

KPXs:                   KPX |
                        KPXs KPX
;

/*
 * A KPX command defines the kerning between two characters.
 */
KPX :           K_KPX   T_ID   T_ID   T_INT    newlines
                {       if (UseAfmKernings)
			  SaveKerningInfo ($2, $3, $4);
		}
;

/*
 * Symbol Font has no composites, optional therefore
 */
Comp :                  |
                        K_StartComposites T_INT newlines
                        Composites 
                        K_EndComposites newlines
;

Composites :            Composite |
                        Composites Composite
;

Composite :             K_CC T_ID T_INT T_SEMICOLON
                             T_ID T_ID T_INT T_INT T_SEMICOLON
                             T_ID T_ID T_INT T_INT T_SEMICOLON
                        newlines
;

End :                   K_EndFontMetrics newlines
;

newlines:               T_AFM_NEWLINE |
                        newlines T_AFM_NEWLINE
;
