/* Copyright 1988 Stephan v. Bechtolsheim */

/* This file is part of the TeXPS Software Package.

The TeXPS Software Package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the TeXPS Software Package
General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
the TeXPS Software Package, but only under the conditions described in the
TeXPS Software Package General Public License.   A copy of this license is
supposed to have been given to you along with TeXPS Software Package so you
can know your rights and responsibilities.  It should be in a
file named CopyrightLong.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */

/*
 * Anything which has to do with units in dvi, tfm, pxl and pdr
 * files and the problem of conversions between the units.
 */

typedef	int PXLU;	/* pxl units */
typedef double PXLF;	/* pxl, as floating point number though	*/
typedef	int DVIU;	/* 32 bit numbers in the DVI file representing	*/
			/* distances (scaled points if no magnification */
			/* is taking place). */
typedef	int FIXES;	/* Unit as choosen in TFM files (32.20 bit
			   numbers which are multiples of the design
			   size of the font. This unit is used in
			   tfm files as well as in the pxl file. */

/* Convert Fixes (32.20bit integer) to floating point number */
#define FIXES_TO_FLOAT(x) ((double)x / (double)(1<<20))

/* Opposite: floating point number to Fixes (32.20 bit integer) */
#define	FLOAT_TO_FIXES(x) ((int)((x+0.0)*(double)(1<<20)))
