/* Copyright 1988 Stephan v. Bechtolsheim */

/* This file is part of the TeXPS Software Package.

The TeXPS Software Package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the TeXPS Software Package
General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
the TeXPS Software Package, but only under the conditions described in the
TeXPS Software Package General Public License.   A copy of this license is
supposed to have been given to you along with TeXPS Software Package so you
can know your rights and responsibilities.  It should be in a
file named CopyrightLong.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */


/*
 * A little C program to install all the PS files which
 * are downloaded by the driver. The source code input files
 * have file extension .psr, the output files written by this
 * program have file extension .pro.
 */

#include <stdio.h>
#if SYS_V == 1
#include <string.h>
#else
#include <strings.h>
#endif

#include "extfil.h"
#include "release.h"

#if SYS_V == 1
#define index  strchr
#define rindex strrchr
#endif

#define TRUE 1
#define FALSE 0

/* Externals. */
extern char *HandleFileNameExtension();
extern int optind;

/* Definitions. */
#define VERSION "3.1"
#define DATE    "July 27, 1990"

/* Forward declarations. */
void Usage();

/* Global variables. */
char *ProgName;
char *InstallDir; /* Where all the files will be installed. */

main (argc, argv)
     int argc;
     char * argv[];
{
  EX_FILES ex_fin;
  EX_FILES ex_fout;

  char pro_source_file_name [256]; /* Prologue file name: source (.psr) */
  char pro_installed_file_name[256]; /* What is the file called when installed (.pro) */
  char *hf;

#define B2L 512
  char buffer_2[B2L];
  char * p;
  char * p2;
  int i, c;
  int ORemoveCommentLines; /* Do you want comment lines to be removed */
  int IncludeDebuggingInfo; /* Do you want to have debugging info to be included */
  int ORemoveLeadingWhiteSpace; /* Do you want to have leading white space to be removed */

#define STATE_REGULAR 0
#define STATE_SEEN_IFDEF 1
#define STATE_INSIDE_CONDITIONAL 2
#define STATE_SEEN_ENDIF 3
  int state;

  ORemoveCommentLines = FALSE;
  IncludeDebuggingInfo = FALSE;
  ORemoveLeadingWhiteSpace = FALSE;

  ProgName = argv[0];
  InitProgName (ProgName, TMPDIR);

  if (argc == 1) {
    Usage();
    exit (1);
  }

  /* Option business. */
  while ((c=getopt(argc, argv, "CDW")) != EOF) {
    switch (c) {
      case 'C': 
        ORemoveCommentLines = TRUE;
	break;
      case 'D':
	IncludeDebuggingInfo = TRUE;
	break;
      case 'W':
	ORemoveLeadingWhiteSpace = TRUE;
	break;
      case '?':
	Fatal2 ("main(): illegal option %c", c);
      default:
	Fatal ("main(): switch / option.");
      }
  }

  state = STATE_REGULAR;

  /* Where all the stuff will be installed */
  InstallDir = argv[optind++];

  /* Loop to make a copy of all source files. */
  while (Strlen(argv[optind]) != 0) {
    /* Compute source file name. */
    strcpy (pro_source_file_name, argv[optind]);
    hf = HandleFileNameExtension (0, pro_source_file_name, "psr");

    /* Compute destintation file name. */
    sprintf (pro_installed_file_name, "%s/%s.pro", InstallDir, hf);
    FExOpen (&ex_fin, EFT_READ, 0, pro_source_file_name, NULL);
    FExOpen (&ex_fout, EFT_WRITE, 0, pro_installed_file_name, NULL);
    fprintf (stderr, "[%s]: %s -> %s\n", ProgName, pro_source_file_name,
	     pro_installed_file_name);

    /* Read in a line from the file. */
    while (ReadLineIntoBuffer (EX_FP(ex_fin), buffer_2, B2L) != EOF) {
      /* (1) Whatever is enclosed inside #ifdef .. #endif has to be thrown out */
      if (IsPrefix (buffer_2, "#ifdef"))
	state = STATE_SEEN_IFDEF;
      if (IsPrefix(buffer_2, "#endif"))
	state = STATE_SEEN_ENDIF;

      /* (2) Removing comments if desired. */
      if (ORemoveCommentLines) {
	if (((p=index(buffer_2, '%')) != NULL &&
             ((p2=index(buffer_2, '(')) == NULL))
            || (p != NULL && p2 != NULL && p2 > p))
	  *p = '\0';
      }
      /* (3) Throw out spaces and tabs at the beginning of a line if desired. */
      if (ORemoveLeadingWhiteSpace)
	RemoveLeadingWhiteSpace(buffer_2);

      /* Remove trailing white space */
      RemoveTrailingWhiteSpace(buffer_2);

      /* Switch states. */
      switch(state) {
        case STATE_REGULAR:
	  break;
	case STATE_SEEN_IFDEF:
	  buffer_2[0] = '\0';
	  state = STATE_INSIDE_CONDITIONAL;
	  break;
	case STATE_INSIDE_CONDITIONAL:
	  if (! IncludeDebuggingInfo)
	    buffer_2[0] = '\0';
	  break;
	case STATE_SEEN_ENDIF:
	  buffer_2[0] = '\0';
	  state = STATE_REGULAR;
	  break;
	default:
	  Fatal ("main(): illegal state.");
	}

      /* Print line only if not empty */
      if (! IsEmptyLine(buffer_2)) {
	i = 0;
	while ((c=buffer_2[i++]) != '\0')
	  putc (c, EX_FP(ex_fout));
	putc ('\n', EX_FP(ex_fout));
      }
    }
    FExClose (&ex_fin);
    FExClose (&ex_fout);
    optind++;
  }
  exit(0);
}

char *UsageText[] = {
  "\tdirectory: where files are to be installed",
  "\t-C: remove all comments from the files",
  "\t-D: include debugging info (normally removed)",
  "\t-W: remove leading white space",
  NULL
};

/*
 * Usage
 * *****
 * Print usage message.
 */
void
Usage()
{
  char **ptr;

  fprintf (stderr, "%s: version %s of %s\n", ProgName, VERSION, DATE);
  fprintf (stderr, "%s: TeXPS version %s of %s\n", ProgName, RELEASE_VERSION, RELEASE_DATE);
  fprintf (stderr, "usage: %s\n", ProgName);
  ptr = &UsageText[0];
  while (*ptr != NULL)
    fprintf (stderr, "%s\n", *ptr++);
}
