/* Copyright 1988 Stephan v. Bechtolsheim */

/* This file is part of the TPS Software Package.

The TPS Software Package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the TPS Software Package
General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
the TPS Software Package, but only under the conditions described in the
TPS Software Package General Public License.   A copy of this license is
supposed to have been given to you along with TPS Software Package so you
can know your rights and responsibilities.  It should be in a
file named CopyrightLong.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */


/*
 * Write the dvitps-cap file which contains a specification
 * of the font file formats the driver will look for.
 * Also check whether the settings make any sense at all.
 *
 * See below for the format of the file being written.
 * The file may contain comments (lines starting with '%').
 *
 * Usage: see Makefile.
 */
#include <stdio.h>
#include "extfil.h"

extern char *tmpdir_default;
char *ProgName;

/*
 * Main
 * ****
 */
main(argc, argv)
     int argc;
     char *argv[];
{
  int i;
  int j;
  int pri[4];
  int n;
  EX_FILES ex_fout;
  char buffer[256];

#define GF 0
#define PK 1
#define PXL 2
#define PDR 3
  
  for (i=0; i<=3; i++) {
    pri[i] = -1;
  }

  ProgName = argv[0];
  InitProgName(argv[0], tmpdir_default);
  FExInit();

  if (argc != 10)
    Fatal ("main(): argc != 10");

  for (i=2; i<=8; i+= 2) {
    /* GF */
    if (Strcmp(argv[i], "GF") == 0){
      if (Strlen(argv[i+1]) != 0) {
	sscanf (argv[i+1], "%d", &pri[GF]);
      }
      continue;
    }
    /* PK */
    if (Strcmp(argv[i], "PK") == 0){
      if (Strlen(argv[i+1]) != 0) {
	sscanf (argv[i+1], "%d", &pri[PK]);
      }
      continue;
    }
    /* PXL */
    if (Strcmp(argv[i], "PXL") == 0){
      if (Strlen(argv[i+1]) != 0) {
	sscanf (argv[i+1], "%d", &pri[PXL]);
      }
      continue;
    }
    /* PDR */
    if (Strcmp(argv[i], "PDR") == 0){
      if (Strlen(argv[i+1]) != 0) {
	sscanf (argv[i+1], "%d", &pri[PDR]);
      }
      continue;
    }

    /* Should never come here! */
    Fatal2 ("Illegal command line argument %s", argv[i]);
  } /* for */

  printf ("Values: GF: %d, PK: %d, PXL: %d, PDR: %d\n",
	  pri[GF], pri[PK], pri[PXL], pri[PDR]);

  /* Count how many are really set. */
  n = 0;
  for (i=0; i<=3; i++) {
    if (pri[i] < -1)
      Fatal ("main(): < -1");
    if (pri[i] > 3)
      Fatal ("main(): > 3");
    if (pri[i] != -1)
      n++;
  }

  printf ("Number of priorities set: %d\n", n);

  /* Now check whether there is indeed one font file type per
     priority only, and whether there are no holes and whether
     the values are in range */
  for (i=0; i<=3; i++) {
    if (pri[i] >= 0) {
      if (pri[i] >= n)
	Fatal2 ("Priority %d exceeded value", pri[i]);
      for (j=i+1; j<=3; j++) {
	if (pri[j] != -1 && (pri[i] == pri[j]))
	  Fatal3 ("main(): Priorities at positions %d and %d identical.",
		  i, j);
      }
    }
  }

  FExOpen(&ex_fout, EFT_WRITE, EFQ_NO_STDOUT, argv[1], NULL);

  fprintf (EX_FP(ex_fout), "%% Capability file for font searches. See source directory\n");
  fprintf (EX_FP(ex_fout), "%% driver/capab for details.\n");

  /* Now add the priorities */
  if (pri[GF] != -1)
    fprintf (EX_FP(ex_fout), "GF:\t%d\n", pri[GF]);
  if (pri[PK] != -1)
    fprintf (EX_FP(ex_fout), "PK:\t%d\n", pri[PK]);
  if (pri[PXL] != -1)
    fprintf (EX_FP(ex_fout), "PXL:\t%d\n", pri[PXL]);
  if (pri[PDR] != -1)
    fprintf (EX_FP(ex_fout), "PDR:\t%d\n", pri[PDR]);

  FExClose(&ex_fout);

  printf ("main(): done\n", n);

  exit (0);
}
