/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.glossaries;

import com.dickimawbooks.texparserlib.CaseChange;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.glossaries.AbstractGlsCommand;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossariesSty;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossaryEntry;
import com.dickimawbooks.texparserlib.latex.glossaries.GlsLabel;
import java.io.IOException;

public class GlsEntryFull
extends AbstractGlsCommand {
    protected boolean isPlural;
    protected CaseChange caseChange;

    public GlsEntryFull(GlossariesSty glossariesSty) {
        this("glsentryfull", CaseChange.NO_CHANGE, false, glossariesSty);
    }

    public GlsEntryFull(String string, boolean bl, GlossariesSty glossariesSty) {
        this(string, CaseChange.NO_CHANGE, bl, glossariesSty);
    }

    public GlsEntryFull(String string, CaseChange caseChange, GlossariesSty glossariesSty) {
        this(string, caseChange, false, glossariesSty);
    }

    public GlsEntryFull(String string, CaseChange caseChange, boolean bl, GlossariesSty glossariesSty) {
        super(string, glossariesSty);
        this.caseChange = caseChange;
        this.isPlural = bl;
    }

    @Override
    public Object clone() {
        return new GlsEntryFull(this.getName(), this.getCaseChange(), this.isPlural(), this.getSty());
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        GlsLabel glsLabel = this.popEntryLabel(teXParser, teXObjectList);
        GlossaryEntry glossaryEntry = glsLabel.getEntry();
        LaTeXParserListener laTeXParserListener = (LaTeXParserListener)teXParser.getListener();
        TeXObjectList teXObjectList2 = laTeXParserListener.createStack();
        if (glossaryEntry == null) {
            this.sty.undefWarnOrError(teXObjectList, "glossaries.entry.not.defined", glsLabel.getLabel());
        } else {
            ControlSequence controlSequence;
            switch (this.caseChange) {
                case SENTENCE: {
                    if (this.isPlural) {
                        if (this.sty.isExtra()) {
                            controlSequence = laTeXParserListener.getControlSequence("Glsxtrinlinefullplformat");
                            break;
                        }
                        controlSequence = laTeXParserListener.getControlSequence("Genplacrfullformat");
                        break;
                    }
                    if (this.sty.isExtra()) {
                        controlSequence = laTeXParserListener.getControlSequence("Glsxtrinlinefullformat");
                        break;
                    }
                    controlSequence = laTeXParserListener.getControlSequence("Genacrfullformat");
                    break;
                }
                default: {
                    if (this.isPlural) {
                        if (this.sty.isExtra()) {
                            controlSequence = laTeXParserListener.getControlSequence("glsxtrinlinefullplformat");
                            break;
                        }
                        controlSequence = laTeXParserListener.getControlSequence("genplacrfullformat");
                        break;
                    }
                    controlSequence = this.sty.isExtra() ? laTeXParserListener.getControlSequence("glsxtrinlinefullplformat") : laTeXParserListener.getControlSequence("genacrfullformat");
                }
            }
            teXObjectList2.add(controlSequence);
            teXObjectList2.add(glsLabel);
            teXObjectList2.add(laTeXParserListener.createGroup());
        }
        return teXObjectList2;
    }

    public boolean isPlural() {
        return this.isPlural;
    }

    public CaseChange getCaseChange() {
        return this.caseChange;
    }
}

