/*
 * Decompiled with CFR 0.152.
 */
package nts.dvi;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import nts.dvi.DviOutputStream;

public class DviFormatWriter {
    private static final int SET = 0;
    private static final int SET1 = 128;
    private static final int SET_RULE = 132;
    private static final int PUT1 = 133;
    private static final int PUT_RULE = 137;
    private static final int NOP = 138;
    private static final int BOP = 139;
    private static final int EOP = 140;
    private static final int PUSH = 141;
    private static final int POP = 142;
    private static final int RIGHT1 = 143;
    private static final int W0 = 147;
    private static final int W1 = 148;
    private static final int X0 = 152;
    private static final int X1 = 153;
    private static final int DOWN1 = 157;
    private static final int Y0 = 161;
    private static final int Y1 = 162;
    private static final int Z0 = 166;
    private static final int Z1 = 167;
    private static final int FNT = 171;
    private static final int FNT1 = 235;
    private static final int SPEC1 = 239;
    private static final int FNT_DEF1 = 243;
    private static final int PRE = 247;
    private static final int POST = 248;
    private static final int POST_POST = 249;
    private static final byte ID_BYTE = 2;
    private static final int DAVID_FUCHS = 223;
    static final MoveStack.Entry NULL_MOVE_STACK_ENTRY;
    private DviOutputStream out;
    private int num;
    private int den;
    private int mag;
    private boolean trouble = false;
    private int numOfPages = 0;
    private int lastPageLoc = -1;
    private boolean pageStarted = false;
    private MoveStack xStack;
    private MoveStack yStack;
    private int maxPushLevel;
    private int pushLevel;
    private Level stack;
    private HashMap fonts;

    private void checkPage() {
        if (!this.pageStarted) {
            throw new RuntimeException("page not started in DVI");
        }
    }

    public int pageCount() {
        return this.numOfPages;
    }

    public int byteCount() {
        return this.currLoc();
    }

    public void startPage(int[] pars) {
        int loc;
        if (!this.pageStarted) {
            loc = this.currLoc();
            this.outByte(139);
            int i = 0;
            while (i < 10) {
                this.outWord(i < pars.length ? pars[i] : 0);
                ++i;
            }
            this.outWord(this.lastPageLoc);
            ++this.numOfPages;
        } else {
            throw new RuntimeException("page already started in DVI");
        }
        this.lastPageLoc = loc;
        this.pageStarted = true;
    }

    public final void moveX(int x) {
        this.checkPage();
        this.xStack.move(x);
    }

    public final void moveY(int y) {
        this.checkPage();
        this.yStack.move(y);
    }

    public void push() {
        this.checkPage();
        this.outByte(141);
        ++this.pushLevel;
        this.stack = new Level(this.xStack.top, this.yStack.top, this.currLoc(), this.stack);
        if (this.maxPushLevel < this.pushLevel) {
            this.maxPushLevel = this.pushLevel;
        }
    }

    public void pop() {
        this.checkPage();
        if (this.stack != null) {
            this.xStack.top = this.stack.xTop;
            this.yStack.top = this.stack.yTop;
            if (this.stack.loc != this.currLoc() || !this.dropLastByte()) {
                this.outByte(142);
            }
            --this.pushLevel;
        } else {
            throw new RuntimeException("too many pops in DVI");
        }
        this.stack = this.stack.next;
    }

    public void endPage() {
        this.checkPage();
        while (this.pushLevel > 0) {
            this.pop();
        }
        this.xStack.top = null;
        this.yStack.top = null;
        this.outByte(140);
        this.pageStarted = false;
    }

    public final void setChar(int code) {
        this.checkPage();
        if (code >= 0 && code < 128) {
            this.outByte(code);
        } else if (code < 256) {
            this.outByte(128);
            this.outByte(code);
        } else {
            this.outPack(128, code);
        }
    }

    public final void putChar(int code) {
        this.checkPage();
        this.outPack(133, code);
    }

    public final void setRule(int h, int w) {
        this.checkPage();
        this.outByte(132);
        this.outWord(h);
        this.outWord(w);
    }

    public final void putRule(int h, int w) {
        this.checkPage();
        this.outByte(137);
        this.outWord(h);
        this.outWord(w);
    }

    public void setSpecial(byte[] spec) {
        this.checkPage();
        int len = spec.length;
        if ((len & 0xFFFFFF00) != 0) {
            this.outByte(242);
            this.outWord(len);
        } else {
            this.outByte(239);
            this.outByte(len);
        }
        this.outBytes(spec);
    }

    public void setFont(int font) {
        this.checkPage();
        if (font >= 0 && font < 64) {
            this.outByte(171 + font);
        } else {
            this.outPack(235, font);
        }
    }

    protected void defFont(int font, FontDef def) {
        this.outPack(243, font);
        this.outWord(def.chksum);
        this.outWord(def.size);
        this.outWord(def.dsize);
        this.outByte(def.dir.length);
        this.outByte(def.name.length);
        this.outBytes(def.dir);
        this.outBytes(def.name);
    }

    public void defFont(int font, int chksum, int size, int dsize, byte[] dir, byte[] name) {
        Integer key = new Integer(font);
        FontDef val = (FontDef)this.fonts.get(key);
        if (val == null) {
            val = new FontDef(chksum, size, dsize, dir, name);
            this.fonts.put(key, val);
            this.defFont(font, val);
        } else if (!val.equals(chksum, size, dsize, dir, name)) {
            throw new RuntimeException("font redefinition in DVI");
        }
    }

    public void close(int maxH, int maxW) {
        if (this.pageStarted) {
            this.endPage();
        }
        int loc = this.currLoc();
        this.outByte(248);
        this.outWord(this.lastPageLoc);
        this.outWord(this.num);
        this.outWord(this.den);
        this.outWord(this.mag);
        this.outWord(maxH);
        this.outWord(maxW);
        this.outHalf(this.maxPushLevel);
        this.outHalf(this.numOfPages);
        Object[] keys = this.fonts.keySet().toArray();
        Arrays.sort(keys);
        int i = keys.length;
        while (i-- > 0) {
            this.defFont((Integer)keys[i], (FontDef)this.fonts.get(keys[i]));
        }
        this.outByte(249);
        this.outWord(loc);
        this.outByte(2);
        i = 4 + (5 - (this.currLoc() + 1 & 3) & 3);
        while (i-- > 0) {
            this.outByte(223);
        }
        try {
            this.out.close();
        }
        catch (IOException e) {
            this.trouble = true;
        }
    }

    private void outHalf(int i) {
        this.outByte(i >>> 8 & 0xFF);
        this.outByte(i & 0xFF);
    }

    private void outWord(int i) {
        this.outByte(i >>> 24 & 0xFF);
        this.outByte(i >>> 16 & 0xFF);
        this.outByte(i >>> 8 & 0xFF);
        this.outByte(i & 0xFF);
    }

    private void outPack(int cmd, int par) {
        int i = 3;
        int abs = par < 0 ? -par : par;
        while (i > 0 && abs >>> 8 * i - 1 == 0) {
            --i;
        }
        this.outByte(cmd + i);
        do {
            this.outByte(par >>> 8 * i & 0xFF);
        } while (i-- > 0);
    }

    private boolean changePack(int loc, int orig, int cmd) {
        int there = this.out.get(loc);
        return there >= 0 && this.out.set(loc, cmd + there - orig);
    }

    private void outByte(int b) {
        try {
            this.out.write(b);
        }
        catch (IOException e) {
            this.trouble = true;
        }
    }

    private void outBytes(byte[] buf) {
        try {
            this.out.write(buf);
        }
        catch (IOException e) {
            this.trouble = true;
        }
    }

    private void outBytes(byte[] buf, int start, int end) {
        try {
            this.out.write(buf, start, end);
        }
        catch (IOException e) {
            this.trouble = true;
        }
    }

    private int currLoc() {
        return this.out.pos();
    }

    private boolean dropLastByte() {
        return this.out.dropLast();
    }

    public DviFormatWriter(OutputStream out, int num, int den, int mag, byte[] comm, int size) {
        DviFormatWriter dviFormatWriter = this;
        if (dviFormatWriter == null) {
            throw null;
        }
        this.xStack = dviFormatWriter.new MoveStack(143, 147, 152, 148, 153);
        DviFormatWriter dviFormatWriter2 = this;
        if (dviFormatWriter2 == null) {
            throw null;
        }
        this.yStack = dviFormatWriter2.new MoveStack(157, 161, 166, 162, 167);
        this.maxPushLevel = 0;
        this.pushLevel = 0;
        this.stack = null;
        this.fonts = new HashMap();
        this.out = out instanceof DviOutputStream ? (DviOutputStream)out : new DviOutputStream(out, size);
        this.num = num;
        this.den = den;
        this.mag = mag;
        this.outByte(247);
        this.outByte(2);
        this.outWord(num);
        this.outWord(den);
        this.outWord(mag);
        int len = comm.length;
        if (len > 255) {
            len = 255;
        }
        this.outByte(len);
        this.outBytes(comm, 0, len);
    }

    public DviFormatWriter(OutputStream out, int num, int den, int mag, byte[] comm) {
        this(out, num, den, mag, comm, 0);
    }

    private class MoveStack {
        int normal;
        int y0;
        int z0;
        int y1;
        int z1;
        Entry top = null;

        void move(int size) {
            Entry ent = this.top;
            boolean ySeen = false;
            boolean zSeen = false;
            MoveStack moveStack = this;
            if (moveStack == null) {
                throw null;
            }
            this.top = moveStack.new Entry(size, this.top);
            while (ent != null) {
                if (size == ent.size) {
                    if (!ySeen && ent.yOK) {
                        if (!ent.here) {
                            if (!DviFormatWriter.this.changePack(ent.loc, this.normal, this.y1)) break;
                            ent.here = true;
                            ent.zOK = false;
                        }
                        DviFormatWriter.this.outByte(this.y0);
                        this.top.here = true;
                        this.top.zOK = false;
                        Entry e = this.top;
                        while ((e = e.next) != ent) {
                            e.yOK = false;
                        }
                        return;
                    }
                    if (!zSeen && ent.zOK) {
                        if (!ent.here) {
                            if (!DviFormatWriter.this.changePack(ent.loc, this.normal, this.z1)) break;
                            ent.here = true;
                            ent.yOK = false;
                        }
                        DviFormatWriter.this.outByte(this.z0);
                        this.top.here = true;
                        this.top.yOK = false;
                        Entry e = this.top;
                        while ((e = e.next) != ent) {
                            e.zOK = false;
                        }
                        return;
                    }
                } else if (ent.here) {
                    if (ent.yOK) {
                        ySeen = true;
                    }
                    if (ent.zOK) {
                        zSeen = true;
                    }
                    if (ySeen && zSeen) break;
                }
                ent = ent.next;
            }
            DviFormatWriter.this.outPack(this.normal, size);
        }

        MoveStack(int normal, int y0, int z0, int y1, int z1) {
            this.normal = normal;
            this.y0 = y0;
            this.z0 = z0;
            this.y1 = y1;
            this.z1 = z1;
        }

        class Entry {
            final int size;
            final Entry next;
            final int loc;
            boolean here = false;
            boolean yOK = true;
            boolean zOK = true;
            private final /* synthetic */ DviFormatWriter this$1;

            Entry(int size, Entry next) {
                this.this$1 = DviFormatWriter.this;
                this.size = size;
                this.next = next;
                this.loc = this.this$1.currLoc();
            }
        }
    }

    private static class Level {
        static final Level NULL;
        final MoveStack.Entry xTop;
        final MoveStack.Entry yTop;
        final int loc;
        final Level next;

        Level(MoveStack.Entry xTop, MoveStack.Entry yTop, int loc, Level next) {
            this.xTop = xTop;
            this.yTop = yTop;
            this.loc = loc;
            this.next = next;
        }
    }

    private static class FontDef {
        static final FontDef NULL;
        final int chksum;
        final int size;
        final int dsize;
        final byte[] dir;
        final byte[] name;

        boolean equals(int chksum, int size, int dsize, byte[] dir, byte[] name) {
            return this.chksum == chksum && this.size == size && this.dsize == dsize && Arrays.equals(this.dir, dir) && Arrays.equals(this.name, name);
        }

        FontDef(int chksum, int size, int dsize, byte[] dir, byte[] name) {
            this.chksum = chksum;
            this.size = size;
            this.dsize = dsize;
            this.dir = dir;
            this.name = name;
            if (dir.length > 255 || name.length > 255) {
                throw new RuntimeException("font name too long in DVI");
            }
        }
    }
}

