/* Module: Strings2 */

#include <string2.h>

void strfill (char *Zeile, int Laenge, char Zeichen)
/* Fllt Zeile mit Laenge Zeichen */
{
  for (; Laenge; Laenge--, Zeile++)
    *Zeile = Zeichen;
  *Zeile = 0;
}


void strdel (char *Zeile)
/* Ein Zeichen (X) wird gelscht. Aufruf: &Zeile[X] */
{
  Zeile++;
  for (;*Zeile; Zeile++)
    *(Zeile - 1) = *Zeile;
  *(Zeile - 1) = 0;
} /* strdel */

void strins (char *Zeile, char Zeichen)
/* Ein Zeichen wird an die Stelle (X) eingefgt.
   Aufruf: &Zeile[X], Zeichen */
{
  char *Hilf = Zeile;

  for (;*Hilf; Hilf++); /* Hilf ans Ende der Zeile setzen */

  for (; (Hilf+1) != Zeile; Hilf--)
    *(Hilf + 1) = *Hilf;
  *Zeile = Zeichen;
} /* strins */

void strextend (char *Zeile, int n)
/* Der String Zeile wird auf "n" Zeichen ohne abschlieendes "\0"
   gestreckt; es werden Leerzeichen angehangen. Ist der String lnger,
   bleibt er dies auch. */
{
  char *Hilf = Zeile;

  for (;*Hilf; Hilf++); /* Hilf ans Ende der Zeile setzen */

  for (; Hilf - Zeile < n; Hilf++)
    *Hilf = ' ';
  *Hilf = '\0';
} /* strextend */

void strcut (char *Zeile)
/* Am Ende der Zeile stehende Leerzeichen werden abgeschnitten */
{
  char *Hilf = Zeile;

  for (;*Hilf; Hilf++); /* Hilf ans Ende der Zeile setzen */

  for (Hilf--;*Hilf == ' ';Hilf--);

  *(Hilf + 1) = '\0';
};


void strrpl ( char *Zeile, char z1, char z2 )
/* In der Zeichenfolge "Zeile" werden alle z1 durch z2 ersetzt */
{
  for ( ; *Zeile; Zeile++ )
  {
    if ( *Zeile == z1 )
      *Zeile = z2;
  };
}; /* strrpl */


char *strchri ( const char *zfolge, char zeichen )
/* Sucht solange rckwrts nach dem Zeichen, bis dieses gefunden wurde.
   Darum !Achtung!, das Zeichen mu vorkommen, Absturzgefahr.
   Ergebnis: Ein Zeiger zu diesem Zeichen */
{
  char *zeiger;

  for ( zeiger = (char *) zfolge; *zeiger == zeichen; zeiger-- );
  return zeiger;
}; /* strchri */


void strsort ( const unsigned char *zfolge, char *erg )
/* Konvertiert den String zfolge in einen sortierfhigen String.
   1. Alle Buchstaben werden in Kleinbuchstaben umgewandelt.
   2. Umlaute verlieren ihre Punkte ( z.B.  --> a )
   3.  --> s
   4. Alle anderen Zeichen werden gestrichen.
   5. erg mu mindestens so gro wie zfolge dimensioniert sein */
{
  int i;

  for ( ; *zfolge; *zfolge++ ) {
    if ( *zfolge >= 'a' && *zfolge <= 'z' ) {
      *erg = *zfolge; erg++; }
    else if ( *zfolge >= 'A' && *zfolge <= 'Z' ) {
      *erg = *zfolge + 32; erg++; }
    else if ( *zfolge == '' || *zfolge == '' ) {
      *erg = 'a'; erg++; }
    else if ( *zfolge == '' || *zfolge == '' ) {
      *erg = 'o'; erg++; }
    else if ( *zfolge == '' || *zfolge == '' ) {
      *erg = 'u'; erg++; }
    else if ( *zfolge == '' ) {
      *erg = 's'; erg++; }
  }; /* for */
  *erg = '\0';
} /* void strsort */
