% mm.pat --- Malayalam transcription definition for TeX pre-processor
% (c) 1993 Jeroen Hellingman
% last edit: 14-JAN-1993

@patterns 0                 % default patterns
"$$"        1 "{\\mmtr "    % begin Malayalam in transcription
"%"         c               % skip comments
"\\"        t               % copy TeX-commands
"\t"        p " "           % tab -> space

@rpatterns 1 patterns ASCII transcription -> scientific transcription in TeX.

"$$"        0 "}"           % switch back to default mode
"$"         e "$ in $$-mode"
">"         f               % eliminate ambiguities
"\\"        t               % copy TeX command
"%"         s               % skip comment
"^"         e "^ in front of non letter"
"^^"        2 ""            % switch to capital mode

"{"         p "{"
"}"         p "}"
"\n"        p "\n"
" "         p " "
"\t"        p " "

"a"         p "a"           % a
"aa"        p "\\=a"        % aa
"A"			p "\\=a"
"i"         p "i"           % i
"ii"        p "{\\=\\i}"    % ii
"I"			p "{\\=\\i}"
"u"         p "u"			% u
"uu"        p "\\=u"		% uu
"U"			p "\\=u"
".r"        p "\\d r"       % vocalic r
".r.r"      p "{\\rii}"  	% vocalic rr
".R"		p "{\\rii}"
".l"        p "\\d l"	    % vocalic l
".l.l"      p "{\\lii}"  	% vocalic ll
".L"		p "{\\lii}"
"e"         p "e"
"ee"        p "\\=e"
"E"			p "\\=e"
"ai"        p "ai"
"o"         p "o"
"oo"        p "\\=o"
"O"			p "\\=o"
"au"        p "au"
"au\""      p "au"          % au length mark

% modifiers

"M"         p "\\d m"       % anusvara
"H"         p "\\d h"       % visarga

% consonants

"k"         p "k"
"kh"        p "kh"
"g"         p "g"
"gh"        p "gh"
"n\""       p "\\.n"        % nga

"c"         p "c"
"ch"        p "ch"
"j"         p "j"
"jh"        p "jh"
"n~"        p "\\~n"        % nya

"T"         p "\\d t"
"Th"        p "\\d th"
"D"         p "\\d d"
"Dh"        p "\\d dh"
"N"         p "\\d n"

"t"         p "t"
"t_"        p "\\b t"       % dental ta
"th"        p "th"
"d"         p "d"
"dh"        p "dh"
"n"         p "n"
"n_"        p "\\b n"       % dental na

"p"         p "p"
"ph"        p "ph"
"f"         p "f"
"b"         p "b"
"bh"        p "bh"
"m"         p "m"

"y"         p "y"
"r"         p "r"
"R"         p "\\b r"
"RR"        p "\\b t"       % double Ra is dental t
"t_t_"      p "\\b t"       % double Ra is dental t
"l"         p "l"
"L"         p "\\d l"
"zh"        p "\\b z"
"v"         p "v"
"sh"        p "\\'s"
"S"         p "\\d s"
"s"         p "s"
"h"         p "h"

"+"         f               % virama
"u+"        p "\\u u"       % half u

% digits

% special

"<>"        f               % join
"@"         f               % non join
"[]"        p "\\dotcircle" % dotted circle

% interpunction

"."         p "."
"`"         p "`"
"'"         p "'"
","         p ","
":"         p ":"
";"         p ";"
"-"         p "-"
"--"        p "--"
"---"       p "---"
"("         p "("
")"         p ")"
"?"         p "?"
"!"         p "!"
"\\%"       p "\\%"

% repeat partial table for correct transcription of anusvar

"Mk"        p "\\.nk"
"Mkh"       p "\\.nkh"
"Mg"        p "\\.ng"
"Mgh"       p "\\.ngh"

"Mc"        p "\\~nc"
"Mch"       p "\\~nch"
"Mj"        p "\\~nj"
"Mjh"       p "\\~njh"

"MT"        p "\\d n\\d t"
"MTh"       p "\\d n\\d th"
"MD"        p "\\d n\\d d"
"MDh"       p "\\d n\\d dh"

"Mt"        p "nt"
"Mth"       p "nth"
"Md"        p "nd"
"Mdh"       p "ndh"

"Mp"        p "mp"
"Mph"       p "mph"
"Mb"        p "mb"
"Mbh"       p "mbh"
"Mf"        p "mf"

% repeat table for capital letters

"^a"        p "A"           % a
"^aa"       p "\\=A"        % aa
"^A"		p "\\=A"
"^i"        p "I"           % i
"^ii"       p "\\=I"        % ii
"^I"		p "\\=I"
"^u"        p "U"
"^uu"       p "\\=U"
"^U"		p "\\=U"
"^.r"       p "\\d R"       % vocalic r
"^.r.r"     p "{\\Rii}"  	% vocalic rr
"^.R"		p "{\\Rii}"
"^.l"       p "\\d L"       % vocalic l
"^.l.l"     p "{\\Lii}"  	% vocalic ll
"^.L"		p "{\\Lii}"
"^e"        p "E"
"^ee"       p "\\=E"
"^E"		p "\\=E"
"^ai"       p "Ai"
"^o"        p "O"
"^oo"       p "\\=O"
"^O"		p "\\=O"
"^au"       p "Au"
"^au\""     p "Au"          % au length mark

% consonants

"^k"        p "K"
"^kh"       p "Kh"
"^g"        p "G"
"^gh"       p "Gh"
"^n\""      p "\\.N"        % nga

"^c"        p "C"
"^ch"       p "Ch"
"^j"        p "J"
"^jh"       p "Jh"
"^n~"       p "\\~N"        % nya

"^T"        p "\\d T"
"^Th"       p "\\d Th"
"^D"        p "\\d D"
"^Dh"       p "\\d Dh"
"^N"        p "\\d N"

"^t"        p "T"
"^t_"       p "\\b T"       % dental ta
"^th"       p "Th"
"^d"        p "D"
"^dh"       p "Dh"
"^n"        p "N"
"^n_"       p "\\b N"

"^p"        p "P"
"^ph"       p "Ph"
"^f"        p "F"
"^b"        p "B"
"^bh"       p "Bh"
"^m"        p "M"

"^y"        p "Y"
"^r"        p "R"
"^R"        p "\\b R"
"^RR"       p "\\b T"       % double Ra is dental t
"^t_t_"     p "\\b T"       % double Ra is dental t
"^l"        p "L"
"^L"        p "\\d L"
"^zh"       p "\\b Z"
"^v"        p "V"
"^sh"       p "\\'S"
"^S"        p "\\d S"
"^s"        p "S"
"^h"        p "H"

@rpatterns 2 patterns ASCII transcription -> scientific transcription in TeX in Caps.

"$$"        0 "}"           % switch back to default mode
"$"         e "$ in $$-mode"
">"         f               % eliminate ambiguities
"\\"        t               % copy TeX command
"%"         s               % skip comment
"^"         s               % no capitals in caps-mode
"^^"        1 ""            % switch to normal mode

"{"         p "{"
"}"         p "}"
"\n"        p "\n"
" "         p " "
"\t"        p " "

"a"         p "A"           % a
"aa"        p "\\=A"        % aa
"A"			p "\\=A"
"i"         p "I"           % i
"ii"        p "\\=I"        % ii
"I"			p "\\=I"
"u"         p "U"
"uu"        p "\\=U"
"U"			p "\\=U"
".r"        p "\\d R"       % vocalic r
".r.r"      p "{\\RII}"  	% vocalic rr
".R"		p "{\\RII}"
".l"        p "\\d L"       % vocalic l
".l.l"      p "{\\LII}"  	% vocalic ll
".L"		p "{\\LII}"
"e"         p "E"
"ee"        p "\\=E"
"E"			p "\\=E"
"ai"        p "AI"
"o"         p "O"
"oo"        p "\\=O"
"O"			p "\\=O"
"au"        p "AU"
"au\""      p "AU"          % au length mark

% modifiers

"M"         p "\\d M"       % anusvara
"H"         p "\\d H"       % visarga

% consonants

"k"         p "K"
"kh"        p "KH"
"g"         p "G"
"gh"        p "GH"
"n\""       p "\\.N"        % nga

"c"         p "C"
"ch"        p "CH"
"j"         p "J"
"jh"        p "JH"
"n~"        p "\\~N"        % nya

"T"         p "\\d T"
"Th"        p "\\d TH"
"D"         p "\\d D"
"Dh"        p "\\d DH"
"N"         p "\\d N"

"t"         p "T"
"t_"        p "\\b T"       % dental ta
"th"        p "TH"
"d"         p "D"
"dh"        p "DH"
"n"         p "N"
"n_"        p "\\b N"

"p"         p "P"
"ph"        p "PH"
"f"         p "F"
"b"         p "B"
"bh"        p "BH"
"m"         p "M"

"y"         p "Y"
"r"         p "R"
"R"         p "\\b R"
"RR"        p "\\b T"       % double Ra is dental t
"t_t_"      p "\\b T"       % double Ra is dental t
"l"         p "L"
"L"         p "\\d L"
"zh"        p "\\b Z"
"v"         p "V"
"sh"        p "\\'S"
"S"         p "\\d S"
"s"         p "S"
"h"         p "H"

"+"         f               % virama
"u+"        p "\\u U"       % half u

% digits

% special

"<>"        f               % join
"@"         f               % non join
"[]"        p "\\dotcircle" % dotted circle

% interpunction

"."         p "."
"`"         p "`"
"'"         p "'"
","         p ","
":"         p ":"
";"         p ";"
"-"         p "-"
"--"        p "--"
"---"       p "---"
"("         p "("
")"         p ")"
"\\%"       p "\\%"

% repeat partial table for correct transcription of anusvar

"Mk"        p "\\.NK"
"Mkh"       p "\\.NKH"
"Mg"        p "\\.NG"
"Mgh"       p "\\.NGH"

"Mc"        p "\\~NC"
"Mch"       p "\\~NCH"
"Mj"        p "\\~NJ"
"Mjh"       p "\\~NJH"

"MT"        p "\\d N\\d T"
"MTh"       p "\\d N\\d TH"
"MD"        p "\\d N\\d D"
"MDh"       p "\\d N\\d DH"

"Mt"        p "NT"
"Mth"       p "NTH"
"Md"        p "ND"
"Mdh"       p "NDH"

"Mp"        p "MP"
"Mph"       p "MPH"
"Mb"        p "MB"
"Mbh"       p "MBH"
"Mf"        p "MF"

@end
