# beamertheme-csh

A Beamer presentation theme for the Complexity Science Hub Vienna.

## Description

This package provides a Beamer theme following the corporate design of the Complexity Science Hub (CSH). It includes a title page, automatic section slides, source citation commands, and a closing slide with QR code. The theme uses TeX Gyre Heros as the default font.

## Usage

```latex
\documentclass[aspectratio=169]{beamer}
\usetheme{csh}

\title{My Presentation}
\author{Your Name}

\begin{document}

\begin{frame}
    \titlepage
\end{frame}

\section{Introduction}

\begin{frame}{Hello}
    Hello, World!
\end{frame}

\cshclosingslide{Your Name}{your.email@csh.ac.at}{https://csh.ac.at}

\end{document}
```

## Features

- Title page with CSH branding
- Automatic section slides
- Source citations: `\source{Your citation}`
- Closing slide with QR code: `\cshclosingslide{Name}{Email}{URL}`

## Installation

Copy all `.sty` files and the `logos/` folder to your project directory, or install to your TEXMF tree.

## License

LPPL 1.3c

## Author

Complexity Science Hub - https://csh.ac.at
