/*
 * Copyright 1991 Klaus Zitzmann, 1993-1996 Johannes Sixt
 *
 * Permission to use, copy, modify and distribute this software and its
 * documentation for any purpose other than its commercial exploitation
 * is hereby granted without fee, provided that the above copyright
 * notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation. The authors
 * make no representations about the suitability of this software for
 * any purpose. It is provided "as is" without express or implied warranty.
 *
 * THE AUTHORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Authors: Klaus Zitzmann <zitzmann@infko.uni-koblenz.de>
 *          Johannes Sixt <Johannes.Sixt@telecom.at>
 */


/* Tokens returned by yylex() */
#define   TOK_BEGIN           1
#define   TOK_END             2

#define   TOK_TEXT            3
#define   TOK_LETTERS_OPT     4

#define   TOK_FLOAT           5

#define   TOK_PUT             6
#define   TOK_FRAMEBOX        7
#define   TOK_DASHBOX         8
#define   TOK_LINE            9
#define   TOK_VECTOR         10
#define   TOK_CIRCLE         11
#define   TOK_CIRCLE_AST     12
#define   TOK_OVAL           13
#define   TOK_RULE           14
#define   TOK_MAKEBOX        15
#define	  TOK_BEZIER	     16
#define	  TOK_QBEZIER	     17

#define   TOK_UNITLENGTH     20
#define   TOK_UNIT           21
#define   TOK_DIM_UNITLENGTH 22

#define   TOK_THICKLINE	     23
#define   TOK_THINLINE       24
typedef enum {
	UnitPT, UnitCM, UnitMM, UnitPC, UnitIN, UnitBP, UnitDD, UnitCC, UnitSP,
        UnitEM
} Unit;

void yyinitscan(FILE *fp);	/* initialize everything; call for each file */
int yylex(void);		/* returns next recognized token */

extern int lineno;
extern float yyfloatval;
extern char yystrval[MAX_TEXT_LEN + 1];
extern Unit yyunit;
