#include "TeXtfm.h"
#include <cctype>
#include <iostream>
#include <iomanip>

using namespace std;

static void showDimensions
(
   ostream&           os,
   const TeXtfm&      tfm,
   const char*        msg,
   unsigned           eLen,
   Int32    (TeXtfm::*f)(US16) const,
   Int32    (TeXtfm::*m)() const
)
{
   os << msg << " - max=" << (tfm.*m)() << endl;
   for (unsigned i = 0, n = tfm.length(eLen);  i != n;  ++i)
   {
      os << "[" << setw(2) << i << "] = " << (tfm.*f)(i) << endl;
   }
} // showDimensions

static void show(ostream& os, const TeXtfm& tfm)
{
   os << "Lengths:" << endl;
   for (unsigned i = 0;  i != (unsigned)TeXtfm::nLen;  ++i)
   {
      os << "  [" << i << " (" << TeXtfm::lengthNames[i] << ")] = " << 
         tfm.length(i) << endl;
   }
   os << endl << "Header:" << endl;
   for (unsigned i = 0, n = tfm.length(TeXtfm::lh);  i != n;  ++i)
   {
      os << "  [" << i << "] = " << tfm.header(i) << endl;
   }
   os << "Design Size = " << tfm.hDesignSize() << " = " << 
                               tfm.designSize() << endl;
   os << "Extra Header: \"" << tfm.extraHeader() << "\"" << endl;
   showDimensions(os, tfm, 
                  "Widths",  TeXtfm::nw, &TeXtfm::width, &TeXtfm::maxWidth);
   showDimensions(os, tfm, 
                  "Heights", TeXtfm::nh, &TeXtfm::height, &TeXtfm::maxHeight);
   showDimensions(os, tfm, 
                  "Depths",  TeXtfm::nd, &TeXtfm::depth,  &TeXtfm::maxDepth);
   showDimensions(os, tfm, 
                  "Italics", TeXtfm::ni, &TeXtfm::italic, &TeXtfm::maxItalic);
   US8  bc = tfm.length(TeXtfm::bc);
   US8  ec = tfm.length(TeXtfm::ec);
   os << "Chars Info:" << endl;
   bool  more = true;
   for (US8  c = bc;  more;  more = (c != ec), ++c)
   {
      TeXtfm::CharInfo  cInf = tfm.char_info(c);
      os << "  [0x" << hex << (int)c;
      if (isprint(c))
      {
         os << '\'' << (char)c << '\'';
      }
      else
      {
         os << "   ";
      }
      TeXtfm::CharInfo::Tag  tag = cInf.tag();
      os << "]: wi=" << (int)cInf.width_index() << 
             ", hi=" << (int)cInf.height_index() << 
             ", di=" << (int)cInf.depth_index() << 
             ", ii=" << (int)cInf.italic_index() << 
             ", tag=" << (int)tag << " = " << 
                          TeXtfm::CharInfo::tagNames[(int)tag] << 
             ", reminder=" << (int)cInf.reminder() << endl;
   }
   os << "LigKern Programs:" << dec << endl;
   for (int i = 0, n = tfm.length(TeXtfm::nl);  i != n;  ++i)
   {
      TeXtfm::LigKern  lk = tfm.lig_kern(i);
      cout << "  [" << i << "]: " << "+."[lk.stop_flag()] << ' ' <<
              "LK"[lk.kern_flag()] << 
              " 0x" << hex << setw(2) << (int)lk.next() << 
              "  reminder=" << dec << (int)lk.reminder() << endl;
   }

   os << "LigKern Owners:" << endl;
   for (int  i = 0, n = tfm.length(TeXtfm::nk);  i != n;  ++i)
   {
      os << "  i=" << i << ": {" << endl;
      TeXtfm::OwnerIter  b, e;
      tfm.ligKernOwners(b, e, i);
      for (;  b != e;  ++b)
      {
         os << "    " << *b << endl;      
      }
      os << "  }" << endl;
   }
} // show


int main(int argc, char** argv)
{
   bool  ok = (argc == 2);
   if (!ok)
   {
      cerr << "Usage: " << argv[0] << " <tfm-file>" << endl;
   }
   else
   {
      TeXtfm  tfm(argv[1]);
      ok = tfm.active();
      if (ok)
      {
         show(cout, tfm);
      }
   }
   cerr << "ok=" << (int)ok << endl;
   return !ok;
} // main
