// $Id: PushDir.cc,v 1.2 2000/10/20 02:25:24 yotam Exp $
#include "PushDir.h"
#include <climits>
#include <unistd.h>


////////////////////////////////////////////////////////////////////////
PushDir::PushDir(const std::string&  dirname) :
   _dir(0)
{
   if (dirname.length())
   {
      bool  ok;
      {
         char buf[PATH_MAX + 1];
         ok = (getcwd(buf, PATH_MAX) != 0);
         const char*  cbuf = buf;
         _savedDir = (ok ? cbuf : ".");
      }
      if (ok && (chdir(dirname.c_str()) == 0))
      {
         _dir = opendir(".");
      }
   }
} // PushDir::PushDir


////////////////////////////////////////////////////////////////////////
PushDir::~PushDir()
{
   pop();
} // PushDir::~PushDir


////////////////////////////////////////////////////////////////////////
void
PushDir::pop()
{
   if (_dir)
   {
      closedir(_dir);  _dir = 0;
      chdir(_savedDir.c_str());
   }
} // PushDir::~PushDir
