// -*- c++ -*-
#if !defined(lIstpAth_H)
#define lIstpAth_H

#include <string>
#include <vector>

class ListDir
{
 public:
   class Filter
   {
    public:
      Filter() {};
      virtual ~Filter() {}
      virtual bool operator()(const std::string&) {return true;}
   };
   static Filter  defaultFilter;
   // In the following the Filter variables should exist only
   // during the constructor or '::make(...).
   ListDir(const std::string&  dir, // Any '//' will recurse at its point
            Filter&             basenameFilter = defaultFilter,
            Filter&             fullnameFilter = defaultFilter);
   virtual ~ListDir() {}
   unsigned  make(const   std::string&  dir, // Any // will recurse
                  Filter&               basenameFilter = defaultFilter,
                  Filter&               fullnameFilter = defaultFilter);
  
   unsigned            nItems() const {return _entries.size();}
   const std::string&  item(unsigned i) const {return _entries[i];}
   void                clear() {_entries.clear();}
   static void         sDel(void* vthis);
   static void         sDelHdl(void* vthis, void*) {sDel(vthis);}
 private:
   void  dirsp(void* pvdir, char* taildir);
   void  tree(void*  pvdir, char* taildir);
   void  addFiles(void* pvdir);
   void  addFile(const char* dirPrefix, const char* basename);
   std::vector<std::string>  _entries;
   Filter*                   _pBaseFilter;  // Used only 
   Filter*                   _pFullFilter;  // while make(...)
   std::string               _node;
}; // ListDir

#endif /* lIstpAth_H */
