#include "ChildDir.h"
#include <unistd.h>
#include <sys/stat.h>
#include <iostream>

////////////////////////////////////////////////////////////////////////
ChildDir::ChildDir(std::string &node, const char* childName):
   _wnode(node),
   _currDirLen(node.length()),
   _dir(0)
{
   struct stat  statBuf;        
   if ((stat(childName, &statBuf) == 0) && S_ISDIR(statBuf.st_mode))
   {
      _symbolic = S_ISLNK(statBuf.st_mode);
      if (chdir(childName) == 0)
      {
         _dir = opendir(".");
         if (_dir)
         {
            node += '/';
            node += childName;
         }
      }
   }
} // ChildDir::ChildDir


////////////////////////////////////////////////////////////////////////
void
ChildDir::pop()
{
   if (_dir)
   {
      closedir(_dir);
      _wnode.erase(_currDirLen);
      const char* updir = (_symbolic ? _wnode.c_str() : "..");
      if (chdir(updir) != 0) 
      {
         cerr << "Failed to chdir to " << updir << endl;
      }
      _dir = 0;
   }
} // ChildDir::~ChildDir
