AC_DEFUN(AC_CHECK_TEXMF, [
AC_ARG_WITHX(texmf,
  [path to an existing texmf tree (\$TEXMFLOCAL)],
  [case "$withval" in
    yes|no) texmf= ;;
    *) texmf="$withval" ;;
  esac], , [=DIR])
AC_PATH_PROG(KPSEWHICH, kpsewhich)
if test -z "$texmf"; then
  AC_MSG_CHECKING([for a texmf tree])
  # If user did not specify something, try it ourselves
  AC_CACHE_VAL(ac_cv_texmf_tree, [
  if test -x "$KPSEWHICH"; then
    ac_cv_texmf_tree=`$KPSEWHICH --expand-var='$TEXMFLOCAL'`
    if test -z "$ac_cv_texmf_tree"; then
      ac_cv_texmf_tree=`$KPSEWHICH --expand-var='$TEXMFMAIN'`
    fi
  fi
  if test -z "$ac_cv_texmf_tree"; then
    # try some common paths
    for i in /usr/share/texmf /usr/local/share/texmf; do
      if test -d $$i; then
        ac_cv_texmf_tree=$$i
        break
      fi
    done
  fi
  ])
  AC_MSG_RESULT("$ac_cv_texmf_tree")
  texmf="$ac_cv_texmf_tree"
else
  ac_cv_texmf_tree="$texmf"
fi
if test -n "$texmf"; then
  AC_DEFINE_UNQUOTED(TEXMFTOP, "$texmf",
    [Define to the full path of an existing texmf tree])
  AC_MSG_CHECKING([for texmf.cnf])
  if test -x "$KPSEWHICH"; then
    texmfcnf=`$KPSEWHICH --format=web2c texmf.cnf`
  fi
  if test -z "$texmfcnf"; then
    texmfcnf="$texmf/web2c/texmf.cnf"
  fi
  if test -f $texmfcnf; then
    AC_MSG_RESULT(yes)
    AC_DEFINE_UNQUOTED(TEXMF_IS_WEB2C, 1,
      [Define if you are using a web2c-based TeX distribution])
    texmf_is_web2c=yes
  else
    AC_MSG_RESULT(no)
    texmf_is_web2c=no
  fi
fi
AC_SUBST(texmf)
])
