# define COMMENT 257
# define EOL 258
# define STRING 259
# define INCLUDE 260
# define DEFINE 261
# define UNDEF 262
# define ELSE 263
# define ENDIF 264
# define CONTENTS 265
# define DBASEVERSION 266
# define LPAREN 267
# define RPAREN 268
# define ANDAND 269
# define OROR 270
# define ECHOTHIS 271
# define BSLASH 272
# define ESCCHAR 273

# line 20 "config.pre.y"
/* $Id: config.pre.y,v 1.23 1994/08/04 03:44:32 gkim Exp $ */

/*
 * config.y
 *
 *	tw.config preprocessor parser for yacc.
 *
 *	This implementation does an unfortunately large number of 
 *	malloc()'s and free()'s to store the lexeme values.  Although
 *	memory leaks are few, too much time is spent doing memory
 *	allocation.
 *
 *	At this point, I would argue that this is not too significant,
 *	since we only run this routine once.
 *
 * Gene Kim
 * Purdue University
 * October 5, 1992
 *
 * Modified by Cal Page to work with linux, March 9, 1994
 */

#include "../include/config.h"
#include <stdio.h>
#ifdef STDLIBH
#include <stdlib.h>
#endif
#ifdef STRINGH
#include <string.h>
#else
#include <strings.h>
#endif
#ifdef MALLOCH
#include <malloc.h>
#endif
#include <assert.h>
#include <sys/param.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "../include/list.h"
#include "../include/tripwire.h"

extern FILE *yyin;
extern FILE *yyout;

#ifdef TW_LINUX
#include <malloc.h>

	void *yy_flex_realloc(void *x,int y) { return realloc(x,y); }
	void *yy_flex_alloc  (int y        ) { return malloc(y);    }
        void yy_flex_free    (void *x      ) { free(x); }

#define yy_strcpy(a,b) strcpy((a),(b))

#endif /* TW_LINUX */

#define INCLUDE_STACK_SZ 	16	/* max num of nested includes */

int yaccdebuglevel = 0;

static int linenumber = 1;

static FILE *fp_stack[INCLUDE_STACK_SZ];
static int linenumber_stack[INCLUDE_STACK_SZ];
static char *filename_stack[INCLUDE_STACK_SZ];
static int stackpointer = 0;
static int found_db_version = 0;
static struct list **pp_entry_list_global = NULL;

static char currparsefile[MAXPATHLEN+1024];

/* prototypes */
static char *string_dequote();
static void include_push();
static FILE *include_pop();

/* this is for some versions of flex and bison, who don't make any
 * effort to look like lex and yacc.
 */

#ifdef LINUX
extern FILE **yyin, *yyout;
void *yy_flex_realloc(void *x,int y) { return realloc(x,y); }
void *yy_flex_alloc  (int y        ) { return malloc(y); }
void  yy_flex_free   (void *x      ) { free(x); }
#endif

struct comp {
    char *string;
    int directive;
};


# line 115 "config.pre.y"
typedef union
#ifdef __cplusplus
	YYSTYPE
#endif
 {
    struct comp *comp;
    char 	*string;
    long 	val;
} YYSTYPE;
# define IFDEF 274
# define IFNDEF 275
# define IFHOST 276
# define IFNHOST 277

#ifdef __STDC__
#include <stdlib.h>
#include <string.h>
#else
#include <malloc.h>
#include <memory.h>
#endif

#include <values.h>

#ifdef __cplusplus

#ifndef yyerror
	void yyerror(const char *);
#endif

#ifndef yylex
#ifdef __EXTERN_C__
	extern "C" { int yylex(void); }
#else
	int yylex(void);
#endif
#endif
	int yyparse(void);

#endif
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
YYSTYPE yylval;
YYSTYPE yyval;
typedef int yytabelem;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#if YYMAXDEPTH > 0
int yy_yys[YYMAXDEPTH], *yys = yy_yys;
YYSTYPE yy_yyv[YYMAXDEPTH], *yyv = yy_yyv;
#else	/* user does initial allocation */
int *yys;
YYSTYPE *yyv;
#endif
static int yymaxdepth = YYMAXDEPTH;
# define YYERRCODE 256

# line 421 "config.pre.y"


#include "config.lex.c"

/*ARGSUSED*/
yyerror(s)
    char *s;
{
     fprintf(stderr, 
	"error: syntax error at line %d in config file\n\t'%s' !\n", 
		++linenumber, currparsefile);
}

/*
 * void
 * tw_macro_parse(char *filename, FILE *fpin, FILE *fpout, 
 *						struct list **pp_entry_list)
 *
 *	wrapper around yyparse(), initiailzing input and output data.
 */

void
tw_macro_parse(filename, fpin, fpout, pp_entry_list)
    char *filename;
    FILE *fpin, *fpout;
    struct list **pp_entry_list;
{
    static int firsttime = 1;
    stackpointer = 0;

    /* set up input and output pointers */
    yyin = fpin;
    yyout = fpout;

#ifdef FLEX_SCANNER
    if (!firsttime) { 
	yyrestart(yyin);
    } else {
	firsttime = 0;
    }
#endif

    /* set up initial filename */
    strcpy( currparsefile, filename );

    pp_entry_list_global = pp_entry_list;

    (void) yyparse();
}

/* counters odd behaviour of flex -- Simon Leinen */
#ifdef yywrap
# undef yywrap
#endif

yywrap()
{
    /* check to see if we've reached the bottom of the @@include stack */
    if (include_pop()) {
	linenumber++;
	return 0;
    }

    /* close up parser */
    return 1;
}

/*
 * static char *
 * string_dequote(char *s)
 *
 *	remove pairs of quoted strings.
 */

static char *
string_dequote(s)
    char *s;
{
    char temp[1024];

    /* do we need to do anything? */
    if (s[0] != '"') 		{ return s; }

    (void) strncpy(temp, s+1, strlen(s) - 2);
    (void) strcpy(s, temp);

    return s;

}

/* 
 * void
 * include_push(char *filename, FILE **p_fp_old)
 *
 *	return a stdio (FILE *) pointer to the opened (filename), saving 
 *	the old (FILE *) pointer and line number on the stack.
 *
 *	returns (NULL) when we pop back to the original file.
 */

static void
include_push(filename, p_fp_old)
    char *filename;
    FILE **p_fp_old;
{
    static FILE *fp;
    char *pc;
    extern int  errno;

    /* check for stack overflow */
    if (stackpointer == INCLUDE_STACK_SZ) {
	fprintf(stderr,
	"error: too many nested includes at line %d in file\n\t'%s' !\n",
		linenumber, currparsefile);
	exit(1);
    }

    /* dequote the include filename */
    string_dequote(filename);

    /* save the old file pointer, filename, and linenumber on the stack */
    fp_stack[stackpointer] = *p_fp_old;

    (void) strcpy((pc = (char *) malloc((unsigned) strlen(currparsefile) + 1)), 
					currparsefile);
    filename_stack[stackpointer] = pc;

    linenumber_stack[stackpointer++] = linenumber;

    /* try opening the file */
    if ((fp = fopen(filename, "r")) == NULL) {
	if (errno == ENOENT) {
	    fprintf(stderr,
"error: @@include '%s': file not found at line %d in config file\n\t'%s' !\n",
		    filename, linenumber, currparsefile);
	    exit(1);
	}
	else {
	    char msg[100];
	    sprintf(msg, "%s: fopen()", filename);
	    perror(msg);
	    exit(1);
	}
    }

    /* replace old pointer with new */
    *p_fp_old = fp;

    /* reset line number and filename */
    linenumber = 0;
    strcpy( currparsefile, filename );
}

/*
 * FILE *
 * include_pop()
 *
 *	pop the last file structure off the @@include stack.
 *
 *	returns NULL when we've exhausted the stack.
 */

static FILE *
include_pop()
{
    /* check for stack underflow */
    if (stackpointer-- == 0)
	return NULL;
    (void) fclose(yyin);

    /* pop off the line numbers and the stdio file pointer */
    yyin = fp_stack[stackpointer];

#ifdef FLEX_SCANNER
    yyrestart(yyin);
#endif

    linenumber = linenumber_stack[stackpointer];
    strcpy( currparsefile, filename_stack[stackpointer] );
    free(filename_stack[stackpointer]);

    return yyin;
}

int
check_varname(pc)
    char *pc;
{
    for (; *pc; pc++) {
	if (!(isalnum(*pc) || (*pc == '_'))) {
	    fprintf(stderr,
"warning: illegal character '%c' in @@define at line %d in file\n\t'%s' !\n",
		*pc, linenumber, currparsefile);
	}
    }
    return 0;
}

yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 35,
-1, 54,
	264, 10,
	-2, 35,
-1, 55,
	264, 10,
	-2, 35,
-1, 56,
	264, 10,
	-2, 35,
-1, 57,
	264, 10,
	-2, 35,
-1, 69,
	264, 9,
	-2, 35,
	};
# define YYNPROD 37
# define YYLAST 115
yytabelem yyact[]={

    11,     5,     6,    62,    18,    12,    14,    11,     5,     6,
    72,    13,    12,    14,     7,     8,     9,    10,    13,    39,
    40,     7,     8,     9,    10,    52,    39,    40,    47,    34,
    35,    34,    35,    18,    18,    71,    70,    66,    68,    18,
    67,    26,    22,    16,    18,    53,    51,    48,    46,    15,
    23,    54,    59,    25,    43,    17,    19,    20,    41,    38,
    27,    27,    29,    30,    28,    32,    21,    61,    36,     4,
    33,    60,     2,     3,     1,    24,    58,    27,     0,     0,
    42,    31,    17,     0,     0,     0,     0,     0,     0,    37,
    27,    27,     0,    49,    50,     0,     0,     0,     0,     0,
    55,    44,    45,    56,     0,    57,     0,     0,    63,    64,
    65,     0,    17,     0,    69 };
yytabelem yypact[]={

-10000000,  -253,-10000000,  -209,  -215,  -255,  -255,  -225,  -225,  -226,
  -226,  -255,  -255,-10000000,  -255,-10000000,-10000000,-10000000,-10000000,  -255,
-10000000,  -238,  -225,-10000000,  -238,  -250,  -226,-10000000,  -250,-10000000,
-10000000,  -255,-10000000,-10000000,  -225,  -225,  -210,  -240,  -211,  -226,
  -226,  -212,  -243,  -213,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,  -260,  -260,  -260,  -260,-10000000,  -227,
  -218,  -220,-10000000,  -228,  -229,  -254,-10000000,-10000000,-10000000,  -253,
-10000000,-10000000,-10000000 };
yytabelem yypgo[]={

     0,    50,    67,    71,    51,    76,    52,    66,    53,    74,
    72,    68,    59,    58,    54 };
yytabelem yyr1[]={

     0,     9,     9,    10,    10,     4,     4,     5,     5,     6,
     6,     7,     7,     7,     7,     8,     8,     8,     8,     3,
     3,     3,    11,     3,    12,     3,    13,     3,    14,     3,
     3,     3,     3,     3,     2,     2,     1 };
yytabelem yyr2[]={

     0,     4,     0,     5,     5,     5,     1,     5,     5,     5,
     1,     7,     7,     7,     3,     7,     7,     7,     3,     5,
     7,     5,     1,    15,     1,    15,     1,    15,     1,    15,
     5,     5,     5,     5,     5,     1,     3 };
yytabelem yychk[]={

-10000000,    -9,   -10,    -3,    -2,   261,   262,   274,   275,   276,
   277,   260,   265,   271,   266,   258,   258,    -1,   259,    -1,
    -1,    -7,   267,    -1,    -7,    -8,   267,    -1,    -8,    -1,
    -1,    -2,    -1,    -1,   269,   270,   -11,    -7,   -12,   269,
   270,   -13,    -8,   -14,    -7,    -7,   258,   268,   258,    -8,
    -8,   258,   268,   258,    -4,    -4,    -4,    -4,    -5,    -6,
    -3,    -2,   263,    -6,    -6,    -6,   264,   258,   258,    -4,
   264,   264,   264 };
yytabelem yydef[]={

     2,    -2,     1,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,    35,     0,     3,     4,    34,    36,    19,
    21,    22,     0,    14,    24,    26,     0,    18,    28,    30,
    31,    32,    33,    20,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,    12,    13,     6,    11,     6,    16,
    17,     6,    15,     6,    -2,    -2,    -2,    -2,     5,     0,
     0,     0,     6,     0,     0,     0,    23,     7,     8,    -2,
    25,    27,    29 };
typedef struct
#ifdef __cplusplus
	yytoktype
#endif
{ char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"COMMENT",	257,
	"EOL",	258,
	"STRING",	259,
	"INCLUDE",	260,
	"DEFINE",	261,
	"UNDEF",	262,
	"ELSE",	263,
	"ENDIF",	264,
	"CONTENTS",	265,
	"DBASEVERSION",	266,
	"LPAREN",	267,
	"RPAREN",	268,
	"ANDAND",	269,
	"OROR",	270,
	"ECHOTHIS",	271,
	"BSLASH",	272,
	"ESCCHAR",	273,
	"IFDEF",	274,
	"IFNDEF",	275,
	"IFHOST",	276,
	"IFNHOST",	277,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"lines : lines line",
	"lines : /* empty */",
	"line : directive EOL",
	"line : words EOL",
	"colines : colines coline",
	"colines : /* empty */",
	"coline : directive EOL",
	"coline : words EOL",
	"else : ELSE colines",
	"else : /* empty */",
	"if_expr : LPAREN if_expr RPAREN",
	"if_expr : if_expr ANDAND if_expr",
	"if_expr : if_expr OROR if_expr",
	"if_expr : word",
	"host_expr : LPAREN host_expr RPAREN",
	"host_expr : host_expr ANDAND host_expr",
	"host_expr : host_expr OROR host_expr",
	"host_expr : word",
	"directive : DEFINE word",
	"directive : DEFINE word word",
	"directive : UNDEF word",
	"directive : IFDEF if_expr",
	"directive : IFDEF if_expr EOL colines else ENDIF",
	"directive : IFNDEF if_expr",
	"directive : IFNDEF if_expr EOL colines else ENDIF",
	"directive : IFHOST host_expr",
	"directive : IFHOST host_expr EOL colines else ENDIF",
	"directive : IFNHOST host_expr",
	"directive : IFNHOST host_expr EOL colines else ENDIF",
	"directive : INCLUDE word",
	"directive : CONTENTS word",
	"directive : ECHOTHIS words",
	"directive : DBASEVERSION word",
	"words : words word",
	"words : /* empty */",
	"word : STRING",
};
#endif /* YYDEBUG */
# line	1 "/usr/ccs/bin/yaccpar"
/*
 * Copyright (c) 1993 by Sun Microsystems, Inc.
 */

#pragma ident	"@(#)yaccpar	6.12	93/06/07 SMI"

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#define YYNEW(type)	malloc(sizeof(type) * yynewmax)
#define YYCOPY(to, from, type) \
	(type *) memcpy(to, (char *) from, yynewmax * sizeof(type))
#define YYENLARGE( from, type) \
	(type *) realloc((char *) from, yynewmax * sizeof(type))
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-10000000)

/*
** global variables used by the parser
*/
YYSTYPE *yypv;			/* top of value stack */
int *yyps;			/* top of state stack */

int yystate;			/* current state */
int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



#ifdef YYNMBCHARS
#define YYLEX()		yycvtok(yylex())
/*
** yycvtok - return a token if i is a wchar_t value that exceeds 255.
**	If i<255, i itself is the token.  If i>255 but the neither 
**	of the 30th or 31st bit is on, i is already a token.
*/
#if defined(__STDC__) || defined(__cplusplus)
int yycvtok(int i)
#else
int yycvtok(i) int i;
#endif
{
	int first = 0;
	int last = YYNMBCHARS - 1;
	int mid;
	wchar_t j;

	if(i&0x60000000){/*Must convert to a token. */
		if( yymbchars[last].character < i ){
			return i;/*Giving up*/
		}
		while ((last>=first)&&(first>=0)) {/*Binary search loop*/
			mid = (first+last)/2;
			j = yymbchars[mid].character;
			if( j==i ){/*Found*/ 
				return yymbchars[mid].tvalue;
			}else if( j<i ){
				first = mid + 1;
			}else{
				last = mid -1;
			}
		}
		/*No entry in the table.*/
		return i;/* Giving up.*/
	}else{/* i is already a token. */
		return i;
	}
}
#else/*!YYNMBCHARS*/
#define YYLEX()		yylex()
#endif/*!YYNMBCHARS*/

/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
#if defined(__STDC__) || defined(__cplusplus)
int yyparse(void)
#else
int yyparse()
#endif
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */

#if defined(__cplusplus) || defined(lint)
/*
	hacks to please C++ and lint - goto's inside switch should never be
	executed; yypvt is set to 0 to avoid "used before set" warning.
*/
	static int __yaccpar_lint_hack__ = 0;
	switch (__yaccpar_lint_hack__)
	{
		case 1: goto yyerrlab;
		case 2: goto yynewstate;
	}
	yypvt = 0;
#endif

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

#if YYMAXDEPTH <= 0
	if (yymaxdepth <= 0)
	{
		if ((yymaxdepth = YYEXPAND(0)) <= 0)
		{
			yyerror("yacc initialization error");
			YYABORT;
		}
	}
#endif

	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */
	goto yystack;	/* moved from 6 lines above to here to please C++ */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int yyps_index = (yy_ps - yys);
			int yypv_index = (yy_pv - yyv);
			int yypvt_index = (yypvt - yyv);
			int yynewmax;
#ifdef YYEXPAND
			yynewmax = YYEXPAND(yymaxdepth);
#else
			yynewmax = 2 * yymaxdepth;	/* double table size */
			if (yymaxdepth == YYMAXDEPTH)	/* first time growth */
			{
				char *newyys = (char *)YYNEW(int);
				char *newyyv = (char *)YYNEW(YYSTYPE);
				if (newyys != 0 && newyyv != 0)
				{
					yys = YYCOPY(newyys, yys, int);
					yyv = YYCOPY(newyyv, yyv, YYSTYPE);
				}
				else
					yynewmax = 0;	/* failed */
			}
			else				/* not first time */
			{
				yys = YYENLARGE(yys, int);
				yyv = YYENLARGE(yyv, YYSTYPE);
				if (yys == 0 || yyv == 0)
					yynewmax = 0;	/* failed */
			}
#endif
			if (yynewmax <= yymaxdepth)	/* tables not expanded */
			{
				yyerror( "yacc stack overflow" );
				YYABORT;
			}
			yymaxdepth = yynewmax;

			yy_ps = yys + yyps_index;
			yy_pv = yyv + yypv_index;
			yypvt = yyv + yypvt_index;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = YYLEX() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = YYLEX() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
			skip_init:
				yynerrs++;
				/* FALLTHRU */
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 3:
# line 141 "config.pre.y"
{
		/*
		linenumber++;
		*/

		if (yypvt[-1].string)	{ 
		    fprintf(yyout, "%s\n", yypvt[-1].string); 
		    free(yypvt[-1].string);
		}
	    } break;
case 4:
# line 152 "config.pre.y"
{
		/*
		linenumber++; 
		*/

		if (yypvt[-1].string)	{ 
		    fprintf(yyout, "%s\n", yypvt[-1].string); 
		    free(yypvt[-1].string);
		}
	    } break;
case 5:
# line 166 "config.pre.y"
{
	    	/* If coline is null, just pass on colines. */
	    	if (yypvt[-0].string == NULL) {
		    yyval.string = yypvt[-1].string;
		} else {
		    /* concatenate the two terminals together */
		    if (yypvt[-1].string == NULL) {
			yyval.string = (char *) malloc((unsigned) strlen(yypvt[-0].string) + 1);
			yyval.string[0] = '\0';
		    }
		    else {
			yyval.string = (char *) malloc((unsigned) 
					    (strlen(yypvt[-1].string) + strlen(yypvt[-0].string)) + 2);
			(void) strcpy(yyval.string, yypvt[-1].string);
			(void) strcat(yyval.string, "\n");
    
			/* free up the left component */
			free(yypvt[-1].string);
		    }
		    (void) strcat(yyval.string, yypvt[-0].string);
    
		    /* free up the right component */
		    if (yypvt[-0].string)
			free(yypvt[-0].string);
		}
		SPDEBUG(11) printf("--(coline)--> (%s)\n", yyval.string);
	    } break;
case 6:
# line 194 "config.pre.y"
{
		yyval.string = NULL;
	    } break;
case 7:
# line 199 "config.pre.y"
{ yyval.string = yypvt[-1].string; /* linenumber++; */} break;
case 8:
# line 200 "config.pre.y"
{ yyval.string = yypvt[-1].string; /* linenumber++; */} break;
case 9:
# line 204 "config.pre.y"
{
		yyval.string = yypvt[-0].string;
	    } break;
case 10:
# line 208 "config.pre.y"
{
		yyval.string = NULL;
	    } break;
case 11:
# line 214 "config.pre.y"
{ 
		yyval.val = yypvt[-1].val;
	    } break;
case 12:
# line 218 "config.pre.y"
{
		yyval.val = yypvt[-2].val && yypvt[-0].val;
	    } break;
case 13:
# line 222 "config.pre.y"
{
		yyval.val = yypvt[-2].val || yypvt[-0].val;
	    } break;
case 14:
# line 226 "config.pre.y"
{
		check_varname(yypvt[-0].comp->string);
		yyval.val = tw_mac_ifdef(yypvt[-0].comp->string);
	    } break;
case 15:
# line 232 "config.pre.y"
{ 
		yyval.val = yypvt[-1].val;
	    } break;
case 16:
# line 236 "config.pre.y"
{
		yyval.val = yypvt[-2].val && yypvt[-0].val;
	    } break;
case 17:
# line 240 "config.pre.y"
{
		yyval.val = yypvt[-2].val || yypvt[-0].val;
	    } break;
case 18:
# line 244 "config.pre.y"
{
		yyval.val = tw_mac_ifhost(yypvt[-0].comp->string);
	    } break;
case 19:
# line 250 "config.pre.y"
{	
		check_varname(yypvt[-0].comp->string);
	   	tw_mac_define(yypvt[-0].comp->string, ""); 
	        yyval.string = NULL; 
	    } break;
case 20:
# line 256 "config.pre.y"
{ 
		check_varname(yypvt[-1].comp->string);
		tw_mac_define(yypvt[-1].comp->string, yypvt[-0].comp->string); yyval.string = NULL; 
	    } break;
case 21:
# line 261 "config.pre.y"
{ 
		check_varname(yypvt[-0].comp->string);
		tw_mac_undef(yypvt[-0].comp->string); yyval.string = NULL; } break;
case 22:
# line 265 "config.pre.y"
{
		yypvt[-1].val = yypvt[-0].val;
	    } break;
case 23:
# line 269 "config.pre.y"
{
		if (yypvt[-6].val) { yyval.string = yypvt[-2].string; }
		else 	{ yyval.string = yypvt[-1].string; }

		/*
		linenumber++;
		*/
	    } break;
case 24:
# line 278 "config.pre.y"
{
		yypvt[-1].val = !yypvt[-0].val;
	    } break;
case 25:
# line 282 "config.pre.y"
{
		if (yypvt[-6].val) { yyval.string = yypvt[-2].string; }
		else 	{ yyval.string = yypvt[-1].string; }

		/*
		linenumber++;
		*/
	    } break;
case 26:
# line 291 "config.pre.y"
{
		yypvt[-1].val = yypvt[-0].val;
	    } break;
case 27:
# line 295 "config.pre.y"
{
		if (yypvt[-6].val) { yyval.string = yypvt[-2].string; }
		else 	{ yyval.string = yypvt[-1].string; }

		/*
		linenumber++;
		*/
	    } break;
case 28:
# line 304 "config.pre.y"
{
		yypvt[-1].val = !yypvt[-0].val;
	    } break;
case 29:
# line 308 "config.pre.y"
{
		if (yypvt[-6].val) { yyval.string = yypvt[-2].string; }
		else 	{ yyval.string = yypvt[-1].string; }

		/*
		linenumber++;
		*/
	    } break;
case 30:
# line 317 "config.pre.y"
{
		/* push a new @@include file onto the include stack */
		include_push(yypvt[-0].comp->string, &yyin);
		yyval.string = NULL;

	    } break;
case 31:
# line 324 "config.pre.y"
{
		char *pc = "@@contents ";

		/* record contents in list */
		list_set(yypvt[-0].comp->string, "", 0, pp_entry_list_global);

		/* reconstruct and emit the entire string */
		yyval.string = (char *) malloc((unsigned) (strlen(yypvt[-0].comp->string) + strlen(pc)) + 1);
		(void) strcpy(yyval.string, pc);
		(void) strcat(yyval.string, yypvt[-0].comp->string);

		/* free up the right side */
		free(yypvt[-0].comp->string);
		free(yypvt[-0].comp);
	    } break;
case 32:
# line 340 "config.pre.y"
{
		fprintf(stderr, "tw.config: echo: %s\n", yypvt[-0].string);
		yyval.string = NULL;
	    } break;
case 33:
# line 345 "config.pre.y"
{
		int version;

		if (sscanf(yypvt[-0].comp->string, "%d", &version) != 1) {
		    yyerror("");
		}

		/* check if the database format is too old */
		if (version != db_version_num) {
		    fprintf(stderr, 
"error: database format %d is no longer supported!\n\tSee tw.config(5) manual page for details)\n\t'%s' (expecting version %d)!\n",
			version, currparsefile, db_version_num);
		    exit(1);
		}

		/* free up the right side */
		free(yypvt[-0].comp->string);
		free(yypvt[-0].comp);

		/* we must see one of these productions in the file */
		found_db_version = 1;

		yyval.string = NULL;
	    } break;
case 34:
# line 372 "config.pre.y"
{
		/* concatenate the two terminals together */
		if (yypvt[-1].string == NULL) {
		    yyval.string = (char *) malloc((unsigned) strlen(yypvt[-0].comp->string) + 1);
		    yyval.string[0] = '\0';
		}
		else {
		    yyval.string = (char *) malloc((unsigned) 
				(strlen(yypvt[-1].string) + strlen(yypvt[-0].comp->string)) + 2);
		    (void) strcpy(yyval.string, yypvt[-1].string);
		    /* XXX: This doesn't work!
		    if ($2 && (!$2->directive))
		    */
		    if (yypvt[-0].comp)
			(void) strcat(yyval.string, " ");

		    /* free up the left component */
		    free(yypvt[-1].string);
		}
		(void) strcat(yyval.string, yypvt[-0].comp->string);

		/* free up the right component */
		if (yypvt[-0].comp) { 
		    free(yypvt[-0].comp->string);
		    free(yypvt[-0].comp);
		}

		SPDEBUG(11) printf("--(words)--> (%s)\n", yyval.string);
	    } break;
case 35:
# line 402 "config.pre.y"
{
		yyval.string = NULL;
	    } break;
case 36:
# line 408 "config.pre.y"
{
	    	struct comp *pcomp;
		char *pc;

		yyval.comp = (struct comp *) malloc(sizeof(struct comp));

		pc = yypvt[-0].string;
		yyval.comp->string = strcpy((char *) malloc((unsigned) strlen(yypvt[-0].string) + 1), yypvt[-0].string);
		yyval.comp->directive = 0;
	    } break;
# line	532 "/usr/ccs/bin/yaccpar"
	}
	goto yystack;		/* reset registers in driver code */
}

