untrusted comment: verify with openbsd-73-base.pub
RWQS90bYzZ4XFp8ZhwQWR7Wc2HstPBh2Lk9zzQbLHXk9ZoKw/TF0jR0BanGL9HXPT7lJGGKhpcYDmntBCDBNeLiRl2mbW10ijQs=

OpenBSD 7.3 errata 023, December 14, 2023:

Fix out of bounds memory accesses in XRandR and XKB X server extensions.
CVE-2023-6377 CVE-2023-6478

Apply by doing:
    signify -Vep /etc/signify/openbsd-73-base.pub -x 023_xserver.patch.sig \
        -m - | (cd /usr/xenocara && patch -p0)

And then rebuild and install the X server:
    cd /usr/xenocara/xserver
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper build

Index: xserver/Xi/exevents.c
===================================================================
RCS file: /cvs/xenocara/xserver/Xi/exevents.c,v
diff -u -p -r1.27 exevents.c
--- xserver/Xi/exevents.c	7 Feb 2023 06:32:18 -0000	1.27
+++ xserver/Xi/exevents.c	13 Dec 2023 12:39:50 -0000
@@ -611,13 +611,13 @@ DeepCopyPointerClasses(DeviceIntPtr from
         }
 
         if (from->button->xkb_acts) {
-            if (!to->button->xkb_acts) {
-                to->button->xkb_acts = calloc(1, sizeof(XkbAction));
-                if (!to->button->xkb_acts)
-                    FatalError("[Xi] not enough memory for xkb_acts.\n");
-            }
+            size_t maxbuttons = max(to->button->numButtons, from->button->numButtons);
+            to->button->xkb_acts = xnfreallocarray(to->button->xkb_acts,
+                                                   maxbuttons,
+                                                   sizeof(XkbAction));
+            memset(to->button->xkb_acts, 0, maxbuttons * sizeof(XkbAction));
             memcpy(to->button->xkb_acts, from->button->xkb_acts,
-                   sizeof(XkbAction));
+                   from->button->numButtons * sizeof(XkbAction));
         }
         else {
             free(to->button->xkb_acts);
Index: xserver/dix/devices.c
===================================================================
RCS file: /cvs/xenocara/xserver/dix/devices.c,v
diff -u -p -r1.28 devices.c
--- xserver/dix/devices.c	11 Nov 2021 09:03:03 -0000	1.28
+++ xserver/dix/devices.c	13 Dec 2023 12:39:50 -0000
@@ -2525,6 +2525,8 @@ RecalculateMasterButtons(DeviceIntPtr sl
 
     if (master->button && master->button->numButtons != maxbuttons) {
         int i;
+        int last_num_buttons = master->button->numButtons;
+
         DeviceChangedEvent event = {
             .header = ET_Internal,
             .type = ET_DeviceChanged,
@@ -2535,6 +2537,15 @@ RecalculateMasterButtons(DeviceIntPtr sl
         };
 
         master->button->numButtons = maxbuttons;
+        if (last_num_buttons < maxbuttons) {
+            master->button->xkb_acts = xnfreallocarray(master->button->xkb_acts,
+                                                       maxbuttons,
+                                                       sizeof(XkbAction));
+            memset(&master->button->xkb_acts[last_num_buttons],
+                   0,
+                   (maxbuttons - last_num_buttons) * sizeof(XkbAction));
+        }
+
 
         memcpy(&event.buttons.names, master->button->labels, maxbuttons *
                sizeof(Atom));
Index: xserver/randr/rrproperty.c
===================================================================
RCS file: /cvs/xenocara/xserver/randr/rrproperty.c,v
diff -u -p -r1.12.16.1 rrproperty.c
--- xserver/randr/rrproperty.c	25 Oct 2023 08:14:42 -0000	1.12.16.1
+++ xserver/randr/rrproperty.c	13 Dec 2023 12:39:50 -0000
@@ -530,7 +530,7 @@ ProcRRChangeOutputProperty(ClientPtr cli
     char format, mode;
     unsigned long len;
     int sizeInBytes;
-    int totalSize;
+    uint64_t totalSize;
     int err;
 
     REQUEST_AT_LEAST_SIZE(xRRChangeOutputPropertyReq);
Index: xserver/randr/rrproviderproperty.c
===================================================================
RCS file: /cvs/xenocara/xserver/randr/rrproviderproperty.c,v
diff -u -p -r1.3 rrproviderproperty.c
--- xserver/randr/rrproviderproperty.c	29 May 2016 12:02:40 -0000	1.3
+++ xserver/randr/rrproviderproperty.c	13 Dec 2023 12:39:50 -0000
@@ -498,7 +498,7 @@ ProcRRChangeProviderProperty(ClientPtr c
     char format, mode;
     unsigned long len;
     int sizeInBytes;
-    int totalSize;
+    uint64_t totalSize;
     int err;
 
     REQUEST_AT_LEAST_SIZE(xRRChangeProviderPropertyReq);
