untrusted comment: verify with openbsd-72-base.pub
RWQTKNnK3CZZ8CZbJoe2AYVyXoqs65KK6MW/cYstAyqvdkfxmIxGqLUSU3p6udcx5H3Ia7qHmytYCF9iu5zl3im3YFRSbsGzUwM=

OpenBSD 7.2 errata 032, July 19, 2023:

In ssh-agent(1)'s PKCS#11 provider support, remote execution was
possible due to controllable access in low-quality libraries. In
addition to fixing this, the ability to remotely load PKCS#11
libraries is now disabled by default (re-enable with
'-Oallow-remote-pkcs11').

Apply by doing:
    signify -Vep /etc/signify/openbsd-72-base.pub \
        -x 032_ssh_agent.patch.sig -m - | (cd /usr/src && patch -p0)

And then rebuild and install ssh-agent(1) and ssh-pkcs11-helper(8).
    cd /usr/src/usr.bin/ssh
    make obj
    make
    make install
 
Index: usr.bin/ssh/ssh-agent.1
===================================================================
RCS file: /cvs/src/usr.bin/ssh/ssh-agent.1,v
diff -u -p -u -r1.73 ssh-agent.1
--- usr.bin/ssh/ssh-agent.1	31 Mar 2022 17:27:27 -0000	1.73
+++ usr.bin/ssh/ssh-agent.1	14 Jul 2023 12:17:25 -0000
@@ -34,7 +34,7 @@
 .\" (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 .\" THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 .\"
-.Dd $Mdocdate: March 31 2022 $
+.Dd $Mdocdate: October 7 2022 $
 .Dt SSH-AGENT 1
 .Os
 .Sh NAME
@@ -46,11 +46,13 @@
 .Op Fl \&Dd
 .Op Fl a Ar bind_address
 .Op Fl E Ar fingerprint_hash
+.Op Fl O Ar option
 .Op Fl P Ar allowed_providers
 .Op Fl t Ar life
 .Nm ssh-agent
 .Op Fl a Ar bind_address
 .Op Fl E Ar fingerprint_hash
+.Op Fl O Ar option
 .Op Fl P Ar allowed_providers
 .Op Fl t Ar life
 .Ar command Op Ar arg ...
@@ -102,6 +104,45 @@ The default is
 Kill the current agent (given by the
 .Ev SSH_AGENT_PID
 environment variable).
+.It Fl O Ar option
+Specify an option when starting
+.Nm .
+Currently two options are supported:
+.Cm allow-remote-pkcs11
+and
+.Cm no-restrict-websafe .
+.Pp
+The
+.Cm allow-remote-pkcs11
+option allows clients of a forwarded
+.Nm
+to load PKCS#11 or FIDO provider libraries.
+By default only local clients may perform this operation.
+Note that signalling that a
+.Nm
+client remote is performed by
+.Xr ssh 1 ,
+and use of other tools to forward access to the agent socket may circumvent
+this restriction.
+.Pp
+The
+.Cm no-restrict-websafe ,
+instructs
+.Nm
+to permit signatures using FIDO keys that might be web authentication
+requests.
+By default,
+.Nm
+refuses signature requests for FIDO keys where the key application string
+does not start with
+.Dq ssh:
+and when the data to be signed does not appear to be a
+.Xr ssh 1
+user authentication request or a
+.Xr ssh-keygen 1
+signature.
+The default behaviour prevents forwarded access to a FIDO key from also
+implicitly forwarding the ability to authenticate to websites.
 .It Fl P Ar allowed_providers
 Specify a pattern-list of acceptable paths for PKCS#11 provider and FIDO
 authenticator middleware shared libraries that may be used with the
@@ -157,7 +198,8 @@ which in turn can be evaluated in the ca
 .Pp
 In both cases,
 .Xr ssh 1
-looks at these environment variables and uses them to establish a connection to the agent.
+looks at these environment variables
+and uses them to establish a connection to the agent.
 .Pp
 The agent initially does not have any private keys.
 Keys are added using
Index: usr.bin/ssh/ssh-agent.c
===================================================================
RCS file: /cvs/src/usr.bin/ssh/ssh-agent.c,v
diff -u -p -u -r1.292 ssh-agent.c
--- usr.bin/ssh/ssh-agent.c	17 Sep 2022 10:11:29 -0000	1.292
+++ usr.bin/ssh/ssh-agent.c	14 Jul 2023 12:09:42 -0000
@@ -158,6 +158,12 @@ char socket_dir[PATH_MAX];
 /* Pattern-list of allowed PKCS#11/Security key paths */
 static char *allowed_providers;
 
+/*
+ * Allows PKCS11 providers or SK keys that use non-internal providers to
+ * be added over a remote connection (identified by session-bind@openssh.com).
+ */
+static int remote_add_provider;
+
 /* locking */
 #define LOCK_SIZE	32
 #define LOCK_SALT_SIZE	16
@@ -1217,6 +1223,12 @@ process_add_identity(SocketEntry *e)
 		if (strcasecmp(sk_provider, "internal") == 0) {
 			debug_f("internal provider");
 		} else {
+			if (e->nsession_ids != 0 && !remote_add_provider) {
+				verbose("failed add of SK provider \"%.100s\": "
+				    "remote addition of providers is disabled",
+				    sk_provider);
+				goto out;
+			}
 			if (realpath(sk_provider, canonical_provider) == NULL) {
 				verbose("failed provider \"%.100s\": "
 				    "realpath: %s", sk_provider,
@@ -1380,6 +1392,11 @@ process_add_smartcard_key(SocketEntry *e
 		error_f("failed to parse constraints");
 		goto send;
 	}
+	if (e->nsession_ids != 0 && !remote_add_provider) {
+		verbose("failed PKCS#11 add of \"%.100s\": remote addition of "
+		    "providers is disabled", provider);
+		goto send;
+	}
 	if (realpath(provider, canonical_provider) == NULL) {
 		verbose("failed PKCS#11 add of \"%.100s\": realpath: %s",
 		    provider, strerror(errno));
@@ -2035,7 +2052,9 @@ main(int ac, char **av)
 			break;
 		case 'O':
 			if (strcmp(optarg, "no-restrict-websafe") == 0)
-				restrict_websafe  = 0;
+				restrict_websafe = 0;
+			else if (strcmp(optarg, "allow-remote-pkcs11") == 0)
+				remote_add_provider = 1;
 			else
 				fatal("Unknown -O option");
 			break;
Index: usr.bin/ssh/ssh-pkcs11.c
===================================================================
RCS file: /cvs/src/usr.bin/ssh/ssh-pkcs11.c,v
diff -u -p -u -r1.55 ssh-pkcs11.c
--- usr.bin/ssh/ssh-pkcs11.c	18 Nov 2021 21:11:01 -0000	1.55
+++ usr.bin/ssh/ssh-pkcs11.c	14 Jul 2023 12:09:42 -0000
@@ -1512,10 +1512,8 @@ pkcs11_register_provider(char *provider_
 		error("dlopen %s failed: %s", provider_id, dlerror());
 		goto fail;
 	}
-	if ((getfunctionlist = dlsym(handle, "C_GetFunctionList")) == NULL) {
-		error("dlsym(C_GetFunctionList) failed: %s", dlerror());
-		goto fail;
-	}
+	if ((getfunctionlist = dlsym(handle, "C_GetFunctionList")) == NULL)
+		fatal("dlsym(C_GetFunctionList) failed: %s", dlerror());
 	p = xcalloc(1, sizeof(*p));
 	p->name = xstrdup(provider_id);
 	p->handle = handle;
