untrusted comment: verify with openbsd-68-base.pub
RWQZj25CSG5R2hiQ4ynoYCsAZVDZlF0b37bBQpySJWkbBc1y5NNhH3UDD/Ltz/j75htxq3T2Tn7sB3ixSksppGAwyFHCYENXBA4=

OpenBSD 6.8 errata 011, January 11, 2021:

When an NDP entry is invalidated the associated layer 2 address
is not invalidated.

Apply by doing:
    signify -Vep /etc/signify/openbsd-68-base.pub -x 011_nd6.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/netinet6/nd6.c
===================================================================
RCS file: /cvs/src/sys/netinet6/nd6.c,v
diff -u -p -r1.233 nd6.c
--- sys/netinet6/nd6.c	24 Jun 2020 22:03:44 -0000	1.233
+++ sys/netinet6/nd6.c	5 Jan 2021 17:45:25 -0000
@@ -690,8 +690,10 @@ void
 nd6_invalidate(struct rtentry *rt)
 {
 	struct llinfo_nd6 *ln = (struct llinfo_nd6 *)rt->rt_llinfo;
+	struct sockaddr_dl *sdl = satosdl(rt->rt_gateway);
 
 	m_freem(ln->ln_hold);
+	sdl->sdl_alen = 0;
 	ln->ln_hold = NULL;
 	ln->ln_state = ND6_LLINFO_INCOMPLETE;
 	ln->ln_asked = 0;

