untrusted comment: verify with openbsd-65-base.pub
RWSZaRmt1LEQT86XySAB/rGaslagjFfurT4xZ8ATQIsYkUju9Xl3BbXte/HokoLC13++e1kqB97J/tQIJch+2vi6duraWIthAww=

OpenBSD 6.5 errata 011, September 14, 2019:

Fix heap overflow in libexpat CVE-2019-15903.

Apply by doing:
    signify -Vep /etc/signify/openbsd-65-base.pub -x 011_expat.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libexpat:
    cd /usr/src/lib/libexpat
    make obj
    make
    make install

Index: lib/libexpat/lib/xmlparse.c
===================================================================
RCS file: /cvs/src/lib/libexpat/lib/xmlparse.c,v
retrieving revision 1.22
diff -u -p -r1.22 xmlparse.c
--- lib/libexpat/lib/xmlparse.c	22 Aug 2018 13:32:12 -0000	1.22
+++ lib/libexpat/lib/xmlparse.c	10 Sep 2019 23:29:54 -0000
@@ -366,7 +366,7 @@ initializeEncoding(XML_Parser parser);
 static enum XML_Error
 doProlog(XML_Parser parser, const ENCODING *enc, const char *s,
          const char *end, int tok, const char *next, const char **nextPtr,
-         XML_Bool haveMore);
+         XML_Bool haveMore, XML_Bool allowClosingDoctype);
 static enum XML_Error
 processInternalEntity(XML_Parser parser, ENTITY *entity,
                       XML_Bool betweenDecl);
@@ -3993,7 +3993,7 @@ externalParEntProcessor(XML_Parser parse
 
   parser->m_processor = prologProcessor;
   return doProlog(parser, parser->m_encoding, s, end, tok, next,
-                  nextPtr, (XML_Bool)!parser->m_parsingStatus.finalBuffer);
+                  nextPtr, (XML_Bool)!parser->m_parsingStatus.finalBuffer, XML_TRUE);
 }
 
 static enum XML_Error PTRCALL
@@ -4043,7 +4043,7 @@ prologProcessor(XML_Parser parser,
   const char *next = s;
   int tok = XmlPrologTok(parser->m_encoding, s, end, &next);
   return doProlog(parser, parser->m_encoding, s, end, tok, next,
-                  nextPtr, (XML_Bool)!parser->m_parsingStatus.finalBuffer);
+                  nextPtr, (XML_Bool)!parser->m_parsingStatus.finalBuffer, XML_TRUE);
 }
 
 static enum XML_Error
@@ -4054,7 +4054,8 @@ doProlog(XML_Parser parser,
          int tok,
          const char *next,
          const char **nextPtr,
-         XML_Bool haveMore)
+         XML_Bool haveMore,
+         XML_Bool allowClosingDoctype)
 {
 #ifdef XML_DTD
   static const XML_Char externalSubsetName[] = { ASCII_HASH , '\0' };
@@ -4233,6 +4234,11 @@ doProlog(XML_Parser parser,
       }
       break;
     case XML_ROLE_DOCTYPE_CLOSE:
+      if (allowClosingDoctype != XML_TRUE) {
+        /* Must not close doctype from within expanded parameter entities */
+        return XML_ERROR_INVALID_TOKEN;
+      }
+
       if (parser->m_doctypeName) {
         parser->m_startDoctypeDeclHandler(parser->m_handlerArg, parser->m_doctypeName,
                                 parser->m_doctypeSysid, parser->m_doctypePubid, 0);
@@ -5170,7 +5176,7 @@ processInternalEntity(XML_Parser parser,
   if (entity->is_param) {
     int tok = XmlPrologTok(parser->m_internalEncoding, textStart, textEnd, &next);
     result = doProlog(parser, parser->m_internalEncoding, textStart, textEnd, tok,
-                      next, &next, XML_FALSE);
+                      next, &next, XML_FALSE, XML_FALSE);
   }
   else
 #endif /* XML_DTD */
@@ -5217,7 +5223,7 @@ internalEntityProcessor(XML_Parser parse
   if (entity->is_param) {
     int tok = XmlPrologTok(parser->m_internalEncoding, textStart, textEnd, &next);
     result = doProlog(parser, parser->m_internalEncoding, textStart, textEnd, tok,
-                      next, &next, XML_FALSE);
+                      next, &next, XML_FALSE, XML_TRUE);
   }
   else
 #endif /* XML_DTD */
@@ -5244,7 +5250,7 @@ internalEntityProcessor(XML_Parser parse
     parser->m_processor = prologProcessor;
     tok = XmlPrologTok(parser->m_encoding, s, end, &next);
     return doProlog(parser, parser->m_encoding, s, end, tok, next, nextPtr,
-                    (XML_Bool)!parser->m_parsingStatus.finalBuffer);
+                    (XML_Bool)!parser->m_parsingStatus.finalBuffer, XML_TRUE);
   }
   else
 #endif /* XML_DTD */
