untrusted comment: signature from openbsd 6.1 base secret key
RWQEQa33SgQSEhGsXYQsPMQ29Hh4FMZOHsYreRYAALSlQmpR1Cx7TaPHs8Pq/ud2U1af5y+Ktt+j76Ua12NxkSRF+Xk7t70rRQg=

OpenBSD 6.1 errata 025, August 3, 2017:

An out of bounds read could occur during processing of EAPOL frames in
the wireless stack. Information from kernel memory could be leaked to
root in userland via an ieee80211(9) ioctl.

Apply by doing:
    signify -Vep /etc/signify/openbsd-61-base.pub -x 025_ieee80211.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/net80211/ieee80211_ioctl.c
===================================================================
RCS file: /cvs/src/sys/net80211/ieee80211_ioctl.c,v
--- sys/net80211/ieee80211_ioctl.c	23 Mar 2017 04:10:10 -0000	1.52
+++ sys/net80211/ieee80211_ioctl.c	1 Aug 2017 23:07:01 -0000	1.52.4.1
@@ -63,6 +63,10 @@ ieee80211_node2req(struct ieee80211com *
     struct ieee80211_nodereq *nr)
 {
 	uint8_t rssi;
+
+	memset(nr, 0, sizeof(*nr));
+
+	strlcpy(nr->nr_ifname, ic->ic_if.if_xname, sizeof(nr->nr_ifname));
 
 	/* Node address and name information */
 	IEEE80211_ADDR_COPY(nr->nr_macaddr, ni->ni_macaddr);
Index: sys/net80211/ieee80211_pae_input.c
===================================================================
RCS file: /cvs/src/sys/net80211/ieee80211_pae_input.c,v
--- sys/net80211/ieee80211_pae_input.c	1 Mar 2017 20:20:45 -0000	1.28
+++ sys/net80211/ieee80211_pae_input.c	22 Jul 2017 16:48:21 -0000	1.29
@@ -78,7 +78,7 @@ ieee80211_eapol_key_input(struct ieee802
 	struct ether_header *eh;
 	struct ieee80211_eapol_key *key;
 	u_int16_t info, desc;
-	int totlen;
+	int totlen, bodylen, paylen;
 
 	ifp->if_ibytes += m->m_pkthdr.len;
 
@@ -109,12 +109,14 @@ ieee80211_eapol_key_input(struct ieee802
 		goto done;
 
 	/* check packet body length */
-	if (m->m_pkthdr.len < 4 + BE_READ_2(key->len))
+	bodylen = BE_READ_2(key->len);
+	totlen = 4 + bodylen;
+	if (m->m_pkthdr.len < totlen || totlen > MCLBYTES)
 		goto done;
 
 	/* check key data length */
-	totlen = sizeof(*key) + BE_READ_2(key->paylen);
-	if (m->m_pkthdr.len < totlen || totlen > MCLBYTES)
+	paylen = BE_READ_2(key->paylen);
+	if (paylen > totlen - sizeof(*key))
 		goto done;
 
 	info = BE_READ_2(key->info);
