/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.DnsResourceRecord;
import org.pcap4j.util.ByteArrays;

public final class IllegalDnsRData
implements DnsResourceRecord.DnsRData {
    private static final long serialVersionUID = -4966155227455233333L;
    private final byte[] rawData;

    public static IllegalDnsRData newInstance(byte[] rawData, int offset, int length) {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IllegalDnsRData(rawData, offset, length);
    }

    private IllegalDnsRData(byte[] rawData, int offset, int length) {
        this.rawData = ByteArrays.getSubArray(rawData, offset, length);
    }

    private IllegalDnsRData(Builder builder2) {
        if (builder2 == null || builder2.rawData == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder2).append(" builder.rawData: ").append(builder2.rawData);
            throw new NullPointerException(sb.toString());
        }
        this.rawData = ByteArrays.clone(builder2.rawData);
    }

    @Override
    public int length() {
        return this.rawData.length;
    }

    @Override
    public byte[] getRawData() {
        return ByteArrays.clone(this.rawData);
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    @Override
    public String toString(String indent) {
        return this.convertToString(indent, null);
    }

    @Override
    public String toString(String indent, byte[] headerRawData) {
        if (headerRawData == null) {
            throw new NullPointerException("headerRawData is null.");
        }
        return this.convertToString(indent, headerRawData);
    }

    private String convertToString(String indent, byte[] headerRawData) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("Illegal Data:").append(ls).append(indent).append("  data: ").append(ByteArrays.toHexString(this.rawData, "")).append(ls);
        return sb.toString();
    }

    public int hashCode() {
        return Arrays.hashCode(this.rawData);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        IllegalDnsRData other = (IllegalDnsRData)obj;
        return Arrays.equals(this.rawData, other.rawData);
    }

    public static final class Builder {
        private byte[] rawData;

        public Builder() {
        }

        private Builder(IllegalDnsRData obj) {
            this.rawData = obj.rawData;
        }

        public Builder rawData(byte[] rawData) {
            this.rawData = rawData;
            return this;
        }

        public IllegalDnsRData build() {
            return new IllegalDnsRData(this);
        }
    }
}

