/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.loaders;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.openide.util.Exceptions;

public final class UIException {
    private UIException() {
    }

    public static void annotateUser(Throwable throwable, String string, String string2, Throwable throwable2, Date date) {
        AnnException annException = AnnException.findOrCreate(throwable, true);
        LogRecord logRecord = new LogRecord(OwnLevel.USER, string);
        if (throwable2 != null) {
            logRecord.setThrown(throwable2);
        }
        annException.addRecord(logRecord);
        if (string2 != null) {
            Exceptions.attachLocalizedMessage((Throwable)throwable, (String)string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AnnException
    extends Exception
    implements Callable<LogRecord[]> {
        private List<LogRecord> records;

        static AnnException findOrCreate(Throwable throwable, boolean bl) {
            if (throwable instanceof AnnException) {
                return (AnnException)throwable;
            }
            if (throwable.getCause() == null) {
                if (bl) {
                    throwable.initCause(new AnnException());
                }
                return (AnnException)throwable.getCause();
            }
            return AnnException.findOrCreate(throwable.getCause(), bl);
        }

        private AnnException() {
        }

        public synchronized void addRecord(LogRecord logRecord) {
            if (this.records == null) {
                this.records = new ArrayList<LogRecord>();
            }
            this.records.add(logRecord);
        }

        @Override
        public LogRecord[] call() {
            List<LogRecord> list = this.records;
            LogRecord[] logRecordArray = new LogRecord[]{};
            return list == null ? logRecordArray : list.toArray(logRecordArray);
        }
    }

    private static final class OwnLevel
    extends Level {
        public static final Level USER = new OwnLevel("USER", 1973);

        private OwnLevel(String string, int n) {
            super(string, n);
        }
    }
}

