/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (i64vec4(165l, 133l, 193l, 76l) << 0u) => i64vec4(165l, 133l, 193l, 76l)
 * (i64vec4(165l, 133l, 193l, 76l) << 1u) => i64vec4(330l, 266l, 386l, 152l)
 * (i64vec4(165l, 133l, 193l, 76l) << 2u) => i64vec4(660l, 532l, 772l, 304l)
 * (i64vec4(165l, 133l, 193l, 76l) << 5u) => i64vec4(5280l, 4256l, 6176l, 2432l)
 * (i64vec4(165l, 133l, 193l, 76l) << 25u) => i64vec4(5536481280l, 4462739456l, 6476005376l, 2550136832l)
 * (i64vec4(165l, 133l, 193l, 76l) << 31u) => i64vec4(354334801920l, 285615325184l, 414464344064l, 163208757248l)
 * (i64vec4(80l, -15l, -51l, 0l) << 0u) => i64vec4(80l, -15l, -51l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) << 1u) => i64vec4(160l, -30l, -102l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) << 2u) => i64vec4(320l, -60l, -204l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) << 5u) => i64vec4(2560l, -480l, -1632l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) << 25u) => i64vec4(2684354560l, -503316480l, -1711276032l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) << 31u) => i64vec4(171798691840l, -32212254720l, -109521666048l, 0l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) << 0u), i64vec4(165l, 133l, 193l, 76l))) ? 1 : -1] array0;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) << 1u), i64vec4(330l, 266l, 386l, 152l))) ? 1 : -1] array1;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) << 2u), i64vec4(660l, 532l, 772l, 304l))) ? 1 : -1] array2;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) << 5u), i64vec4(5280l, 4256l, 6176l, 2432l))) ? 1 : -1] array3;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) << 25u), i64vec4(5536481280l, 4462739456l, 6476005376l, 2550136832l))) ? 1 : -1] array4;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) << 31u), i64vec4(354334801920l, 285615325184l, 414464344064l, 163208757248l))) ? 1 : -1] array5;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) << 0u), i64vec4(80l, -15l, -51l, 0l))) ? 1 : -1] array6;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) << 1u), i64vec4(160l, -30l, -102l, 0l))) ? 1 : -1] array7;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) << 2u), i64vec4(320l, -60l, -204l, 0l))) ? 1 : -1] array8;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) << 5u), i64vec4(2560l, -480l, -1632l, 0l))) ? 1 : -1] array9;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) << 25u), i64vec4(2684354560l, -503316480l, -1711276032l, 0l))) ? 1 : -1] array10;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) << 31u), i64vec4(171798691840l, -32212254720l, -109521666048l, 0l))) ? 1 : -1] array11;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length());
}
