/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.exceptions.PreparationException;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.EncryptedServerNameIndicationExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.PreSharedKeyExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.handler.factory.HandlerFactory;
import de.rub.nds.tlsattacker.core.protocol.message.ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.HRRKeyShareExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.Preparator;
import de.rub.nds.tlsattacker.core.protocol.preparator.ProtocolMessagePreparator;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.EncryptedServerNameIndicationExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.PreSharedKeyExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.HandshakeMessageSerializer;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class HandshakeMessagePreparator<T extends HandshakeMessage>
extends ProtocolMessagePreparator<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private HandshakeMessageSerializer serializer;
    private final HandshakeMessage msg;

    public HandshakeMessagePreparator(Chooser chooser, T message) {
        super(chooser, message);
        this.msg = message;
    }

    protected void prepareMessageLength(int length) {
        this.msg.setLength(length);
        LOGGER.debug("Length: " + this.msg.getLength().getValue());
    }

    private void prepareMessageType(HandshakeMessageType type) {
        this.msg.setType(type.getValue());
        LOGGER.debug("Type: " + this.msg.getType().getValue());
    }

    @Override
    protected final void prepareProtocolMessageContents() {
        if (this.chooser.getSelectedProtocolVersion().isDTLS()) {
            this.msg.setMessageSequence(this.chooser.getContext().getDtlsWriteHandshakeMessageSequence());
        }
        this.prepareHandshakeMessageContents();
        this.serializer = (HandshakeMessageSerializer)this.msg.getHandler(this.chooser.getContext()).getSerializer(this.msg);
        this.prepareMessageLength(this.serializer.serializeHandshakeMessageContent().length);
        this.prepareMessageType(this.msg.getHandshakeMessageType());
    }

    protected abstract void prepareHandshakeMessageContents();

    protected void prepareExtensions() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        if (this.msg.getExtensions() != null) {
            for (ExtensionMessage extensionMessage : this.msg.getExtensions()) {
                HandshakeMessageType handshakeMessageType = this.msg.getHandshakeMessageType();
                if (extensionMessage instanceof HRRKeyShareExtensionMessage) {
                    handshakeMessageType = HandshakeMessageType.HELLO_RETRY_REQUEST;
                }
                ExtensionHandler handler = HandlerFactory.getExtensionHandler(this.chooser.getContext(), extensionMessage.getExtensionTypeConstant(), handshakeMessageType);
                handler.getPreparator(extensionMessage).prepare();
                try {
                    stream.write((byte[])extensionMessage.getExtensionBytes().getValue());
                }
                catch (IOException ex) {
                    throw new PreparationException("Could not write ExtensionBytes to byte[]", ex);
                }
            }
        }
        this.msg.setExtensionBytes(stream.toByteArray());
        LOGGER.debug("ExtensionBytes: " + ArrayConverter.bytesToHexString((byte[])((byte[])this.msg.getExtensionBytes().getValue())));
    }

    protected void afterPrepareExtensions() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        if (this.msg.getExtensions() != null) {
            for (ExtensionMessage extensionMessage : this.msg.getExtensions()) {
                HandshakeMessageType handshakeMessageType = this.msg.getHandshakeMessageType();
                if (extensionMessage instanceof HRRKeyShareExtensionMessage) {
                    handshakeMessageType = HandshakeMessageType.HELLO_RETRY_REQUEST;
                }
                ExtensionHandler handler = HandlerFactory.getExtensionHandler(this.chooser.getContext(), extensionMessage.getExtensionTypeConstant(), handshakeMessageType);
                ExtensionPreparator preparator = handler.getPreparator(extensionMessage);
                if (handler instanceof PreSharedKeyExtensionHandler && this.msg instanceof ClientHelloMessage && this.chooser.getConnectionEndType() == ConnectionEndType.CLIENT) {
                    ((PreSharedKeyExtensionPreparator)preparator).setClientHello((ClientHelloMessage)this.msg);
                    ((Preparator)preparator).afterPrepare();
                } else if (handler instanceof EncryptedServerNameIndicationExtensionHandler && this.msg instanceof ClientHelloMessage && this.chooser.getConnectionEndType() == ConnectionEndType.CLIENT) {
                    ClientHelloMessage clientHelloMessage = (ClientHelloMessage)this.msg;
                    ((EncryptedServerNameIndicationExtensionPreparator)preparator).setClientHelloMessage(clientHelloMessage);
                    ((Preparator)preparator).afterPrepare();
                }
                try {
                    stream.write((byte[])extensionMessage.getExtensionBytes().getValue());
                }
                catch (IOException ex) {
                    throw new PreparationException("Could not write ExtensionBytes to byte[]", ex);
                }
            }
        }
        this.msg.setExtensionBytes(stream.toByteArray());
        LOGGER.debug("ExtensionBytes: " + ArrayConverter.bytesToHexString((byte[])((byte[])this.msg.getExtensionBytes().getValue())));
    }

    protected void prepareExtensionLength() {
        this.msg.setExtensionsLength(((byte[])this.msg.getExtensionBytes().getValue()).length);
        LOGGER.debug("ExtensionLength: " + this.msg.getExtensionsLength().getValue());
    }
}

