"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryInsightsDashboardsPlugin = void 0;
var _queryInsightsPlugin = require("./clusters/queryInsightsPlugin");
var _routes = require("./routes");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class QueryInsightsDashboardsPlugin {
  constructor(initializerContext) {
    _defineProperty(this, "logger", void 0);
    this.logger = initializerContext.logger.get();
  }
  setup(core, {
    dataSource
  }) {
    const dataSourceEnabled = !!dataSource;
    const router = core.http.createRouter();
    const queryInsightsClient = core.opensearch.legacy.createClient('opensearch_queryInsights', {
      plugins: [_queryInsightsPlugin.QueryInsightsPlugin]
    });
    if (dataSourceEnabled) {
      dataSource.registerCustomApiSchema(_queryInsightsPlugin.QueryInsightsPlugin);
    }

    // @ts-ignore
    core.http.registerRouteHandlerContext('queryInsights_plugin', (_context, _request) => {
      return {
        logger: this.logger,
        queryInsightsClient
      };
    });

    // Register server side APIs
    (0, _routes.defineRoutes)(router, dataSourceEnabled);
    return {};
  }
  start(_core) {
    this.logger.debug('query-insights-dashboards: Started');
    return {};
  }
  stop() {}
}
exports.QueryInsightsDashboardsPlugin = QueryInsightsDashboardsPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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