/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.core.internal.thing;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.config.core.ConfigDescription;
import org.openhab.core.config.core.ConfigDescriptionRegistry;
import org.openhab.core.config.core.dto.ConfigDescriptionDTO;
import org.openhab.core.config.core.dto.ConfigDescriptionDTOMapper;
import org.openhab.core.io.rest.LocaleService;
import org.openhab.core.io.rest.RESTResource;
import org.openhab.core.io.rest.Stream2JSONInputStream;
import org.openhab.core.thing.ThingTypeUID;
import org.openhab.core.thing.dto.ChannelDefinitionDTO;
import org.openhab.core.thing.dto.ChannelGroupDefinitionDTO;
import org.openhab.core.thing.dto.StrippedThingTypeDTO;
import org.openhab.core.thing.dto.StrippedThingTypeDTOMapper;
import org.openhab.core.thing.dto.ThingTypeDTO;
import org.openhab.core.thing.type.BridgeType;
import org.openhab.core.thing.type.ChannelDefinition;
import org.openhab.core.thing.type.ChannelGroupDefinition;
import org.openhab.core.thing.type.ChannelGroupType;
import org.openhab.core.thing.type.ChannelGroupTypeRegistry;
import org.openhab.core.thing.type.ChannelType;
import org.openhab.core.thing.type.ChannelTypeRegistry;
import org.openhab.core.thing.type.ThingType;
import org.openhab.core.thing.type.ThingTypeRegistry;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="thing-types")
@Tag(name="thing-types")
@Component
@JaxrsResource
@JaxrsName(value="thing-types")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class ThingTypeResource
implements RESTResource {
    public static final String PATH_THING_TYPES = "thing-types";
    private final Logger logger = LoggerFactory.getLogger(ThingTypeResource.class);
    private final ChannelTypeRegistry channelTypeRegistry;
    private final ChannelGroupTypeRegistry channelGroupTypeRegistry;
    private final ConfigDescriptionRegistry configDescriptionRegistry;
    private final LocaleService localeService;
    private final ThingTypeRegistry thingTypeRegistry;

    @Activate
    public ThingTypeResource(@Reference ChannelTypeRegistry channelTypeRegistry, @Reference ChannelGroupTypeRegistry channelGroupTypeRegistry, @Reference ConfigDescriptionRegistry configDescriptionRegistry, @Reference LocaleService localeService, @Reference ThingTypeRegistry thingTypeRegistry) {
        this.channelTypeRegistry = channelTypeRegistry;
        this.channelGroupTypeRegistry = channelGroupTypeRegistry;
        this.configDescriptionRegistry = configDescriptionRegistry;
        this.localeService = localeService;
        this.thingTypeRegistry = thingTypeRegistry;
    }

    @GET
    @RolesAllowed(value={"user", "administrator"})
    @Produces(value={"application/json"})
    @Operation(operationId="getThingTypes", summary="Gets all available thing types without config description, channels and properties.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=StrippedThingTypeDTO.class), uniqueItems=true))})})
    public Response getAll(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @QueryParam(value="bindingId") @Parameter(description="filter by binding Id") @Nullable String bindingId) {
        Locale locale = this.localeService.getLocale(language);
        Stream<StrippedThingTypeDTO> typeStream = this.thingTypeRegistry.getThingTypes(locale).stream().map(thingType -> StrippedThingTypeDTOMapper.map((ThingType)thingType, (Locale)locale));
        if (bindingId != null) {
            typeStream = typeStream.filter(type -> type.UID.startsWith(bindingId + ":"));
        }
        return Response.ok((Object)new Stream2JSONInputStream(typeStream)).build();
    }

    @GET
    @RolesAllowed(value={"user", "administrator"})
    @Path(value="/{thingTypeUID}")
    @Produces(value={"application/json"})
    @Operation(operationId="getThingTypeById", summary="Gets thing type by UID.", responses={@ApiResponse(responseCode="200", description="Thing type with provided thingTypeUID does not exist.", content={@Content(schema=@Schema(implementation=ThingTypeDTO.class))}), @ApiResponse(responseCode="404", description="No content")})
    public Response getByUID(@PathParam(value="thingTypeUID") @Parameter(description="thingTypeUID") String thingTypeUID, @HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language) {
        Locale locale = this.localeService.getLocale(language);
        ThingType thingType = this.thingTypeRegistry.getThingType(new ThingTypeUID(thingTypeUID), locale);
        if (thingType != null) {
            return Response.ok((Object)this.convertToThingTypeDTO(thingType, locale)).build();
        }
        return Response.noContent().build();
    }

    private ThingTypeDTO convertToThingTypeDTO(ThingType thingType, Locale locale) {
        ArrayList parameterGroups;
        List parameters;
        ConfigDescription configDescription;
        URI descURI = thingType.getConfigDescriptionURI();
        ConfigDescription configDescription2 = configDescription = descURI == null ? null : this.configDescriptionRegistry.getConfigDescription(descURI, locale);
        if (configDescription != null) {
            ConfigDescriptionDTO configDescriptionDTO = ConfigDescriptionDTOMapper.map((ConfigDescription)configDescription);
            parameters = configDescriptionDTO.parameters;
            parameterGroups = configDescriptionDTO.parameterGroups;
        } else {
            parameters = new ArrayList(0);
            parameterGroups = new ArrayList(0);
        }
        List<ChannelDefinitionDTO> channelDefinitions = this.convertToChannelDefinitionDTOs(thingType.getChannelDefinitions(), locale);
        return new ThingTypeDTO(thingType.getUID().toString(), thingType.getLabel(), thingType.getDescription(), thingType.getCategory(), thingType.isListed(), parameters, channelDefinitions, this.convertToChannelGroupDefinitionDTOs(thingType.getChannelGroupDefinitions(), locale), thingType.getSupportedBridgeTypeUIDs(), thingType.getProperties(), thingType instanceof BridgeType, parameterGroups, thingType.getExtensibleChannelTypeIds());
    }

    private List<ChannelGroupDefinitionDTO> convertToChannelGroupDefinitionDTOs(List<ChannelGroupDefinition> channelGroupDefinitions, Locale locale) {
        ArrayList<ChannelGroupDefinitionDTO> channelGroupDefinitionDTOs = new ArrayList<ChannelGroupDefinitionDTO>();
        for (ChannelGroupDefinition channelGroupDefinition : channelGroupDefinitions) {
            String id = channelGroupDefinition.getId();
            ChannelGroupType channelGroupType = this.channelGroupTypeRegistry.getChannelGroupType(channelGroupDefinition.getTypeUID(), locale);
            String label = channelGroupDefinition.getLabel();
            String description = channelGroupDefinition.getDescription();
            List channelDefinitions = List.of();
            if (channelGroupType == null) {
                this.logger.warn("Cannot find channel group type: {}", (Object)channelGroupDefinition.getTypeUID());
            } else {
                if (label == null) {
                    label = channelGroupType.getLabel();
                }
                if (description == null) {
                    description = channelGroupType.getDescription();
                }
                channelDefinitions = channelGroupType.getChannelDefinitions();
            }
            List<ChannelDefinitionDTO> channelDefinitionDTOs = this.convertToChannelDefinitionDTOs(channelDefinitions, locale);
            channelGroupDefinitionDTOs.add(new ChannelGroupDefinitionDTO(id, label, description, channelDefinitionDTOs));
        }
        return channelGroupDefinitionDTOs;
    }

    private List<ChannelDefinitionDTO> convertToChannelDefinitionDTOs(List<ChannelDefinition> channelDefinitions, Locale locale) {
        ArrayList<ChannelDefinitionDTO> channelDefinitionDTOs = new ArrayList<ChannelDefinitionDTO>();
        for (ChannelDefinition channelDefinition : channelDefinitions) {
            String description;
            ChannelType channelType = this.channelTypeRegistry.getChannelType(channelDefinition.getChannelTypeUID(), locale);
            if (channelType == null) {
                this.logger.warn("Cannot find channel type: {}", (Object)channelDefinition.getChannelTypeUID());
                continue;
            }
            String label = channelDefinition.getLabel();
            if (label == null) {
                label = channelType.getLabel();
            }
            if ((description = channelDefinition.getDescription()) == null) {
                description = channelType.getDescription();
            }
            ChannelDefinitionDTO channelDefinitionDTO = new ChannelDefinitionDTO(channelDefinition.getId(), channelDefinition.getChannelTypeUID().toString(), label, description, channelType.getTags(), channelType.getCategory(), channelType.getState(), channelType.isAdvanced(), channelDefinition.getProperties());
            channelDefinitionDTOs.add(channelDefinitionDTO);
        }
        return channelDefinitionDTOs;
    }
}

