/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct EGLClientPixmapHI")
public class EGLClientPixmapHI
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PDATA;
    public static final int IWIDTH;
    public static final int IHEIGHT;
    public static final int ISTRIDE;

    public EGLClientPixmapHI(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), EGLClientPixmapHI.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public ByteBuffer pData(int capacity) {
        return EGLClientPixmapHI.npData(this.address(), capacity);
    }

    @NativeType(value="EGLint")
    public int iWidth() {
        return EGLClientPixmapHI.niWidth(this.address());
    }

    @NativeType(value="EGLint")
    public int iHeight() {
        return EGLClientPixmapHI.niHeight(this.address());
    }

    @NativeType(value="EGLint")
    public int iStride() {
        return EGLClientPixmapHI.niStride(this.address());
    }

    public EGLClientPixmapHI pData(@NativeType(value="void *") ByteBuffer value) {
        EGLClientPixmapHI.npData(this.address(), value);
        return this;
    }

    public EGLClientPixmapHI iWidth(@NativeType(value="EGLint") int value) {
        EGLClientPixmapHI.niWidth(this.address(), value);
        return this;
    }

    public EGLClientPixmapHI iHeight(@NativeType(value="EGLint") int value) {
        EGLClientPixmapHI.niHeight(this.address(), value);
        return this;
    }

    public EGLClientPixmapHI iStride(@NativeType(value="EGLint") int value) {
        EGLClientPixmapHI.niStride(this.address(), value);
        return this;
    }

    public EGLClientPixmapHI set(ByteBuffer pData, int iWidth, int iHeight, int iStride) {
        this.pData(pData);
        this.iWidth(iWidth);
        this.iHeight(iHeight);
        this.iStride(iStride);
        return this;
    }

    public EGLClientPixmapHI set(EGLClientPixmapHI src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static EGLClientPixmapHI malloc() {
        return (EGLClientPixmapHI)EGLClientPixmapHI.wrap(EGLClientPixmapHI.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static EGLClientPixmapHI calloc() {
        return (EGLClientPixmapHI)EGLClientPixmapHI.wrap(EGLClientPixmapHI.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static EGLClientPixmapHI create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (EGLClientPixmapHI)EGLClientPixmapHI.wrap(EGLClientPixmapHI.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static EGLClientPixmapHI create(long address) {
        return (EGLClientPixmapHI)EGLClientPixmapHI.wrap(EGLClientPixmapHI.class, (long)address);
    }

    @Nullable
    public static EGLClientPixmapHI createSafe(long address) {
        return address == 0L ? null : (EGLClientPixmapHI)EGLClientPixmapHI.wrap(EGLClientPixmapHI.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)EGLClientPixmapHI.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)EGLClientPixmapHI.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)EGLClientPixmapHI.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = EGLClientPixmapHI.__create((int)capacity, (int)SIZEOF);
        return (Buffer)EGLClientPixmapHI.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)EGLClientPixmapHI.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)EGLClientPixmapHI.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static EGLClientPixmapHI mallocStack() {
        return EGLClientPixmapHI.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static EGLClientPixmapHI callocStack() {
        return EGLClientPixmapHI.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static EGLClientPixmapHI mallocStack(MemoryStack stack) {
        return EGLClientPixmapHI.malloc(stack);
    }

    @Deprecated
    public static EGLClientPixmapHI callocStack(MemoryStack stack) {
        return EGLClientPixmapHI.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return EGLClientPixmapHI.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return EGLClientPixmapHI.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return EGLClientPixmapHI.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return EGLClientPixmapHI.calloc(capacity, stack);
    }

    public static EGLClientPixmapHI malloc(MemoryStack stack) {
        return (EGLClientPixmapHI)EGLClientPixmapHI.wrap(EGLClientPixmapHI.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static EGLClientPixmapHI calloc(MemoryStack stack) {
        return (EGLClientPixmapHI)EGLClientPixmapHI.wrap(EGLClientPixmapHI.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)EGLClientPixmapHI.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)EGLClientPixmapHI.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static ByteBuffer npData(long struct, int capacity) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PDATA)), (int)capacity);
    }

    public static int niWidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)IWIDTH);
    }

    public static int niHeight(long struct) {
        return UNSAFE.getInt(null, struct + (long)IHEIGHT);
    }

    public static int niStride(long struct) {
        return UNSAFE.getInt(null, struct + (long)ISTRIDE);
    }

    public static void npData(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PDATA), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void niWidth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)IWIDTH, value);
    }

    public static void niHeight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)IHEIGHT, value);
    }

    public static void niStride(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ISTRIDE, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PDATA)));
    }

    static {
        Struct.Layout layout = EGLClientPixmapHI.__struct((Struct.Member[])new Struct.Member[]{EGLClientPixmapHI.__member((int)POINTER_SIZE), EGLClientPixmapHI.__member((int)4), EGLClientPixmapHI.__member((int)4), EGLClientPixmapHI.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PDATA = layout.offsetof(0);
        IWIDTH = layout.offsetof(1);
        IHEIGHT = layout.offsetof(2);
        ISTRIDE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<EGLClientPixmapHI, Buffer>
    implements NativeResource {
        private static final EGLClientPixmapHI ELEMENT_FACTORY = EGLClientPixmapHI.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected EGLClientPixmapHI getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public ByteBuffer pData(int capacity) {
            return EGLClientPixmapHI.npData(this.address(), capacity);
        }

        @NativeType(value="EGLint")
        public int iWidth() {
            return EGLClientPixmapHI.niWidth(this.address());
        }

        @NativeType(value="EGLint")
        public int iHeight() {
            return EGLClientPixmapHI.niHeight(this.address());
        }

        @NativeType(value="EGLint")
        public int iStride() {
            return EGLClientPixmapHI.niStride(this.address());
        }

        public Buffer pData(@NativeType(value="void *") ByteBuffer value) {
            EGLClientPixmapHI.npData(this.address(), value);
            return this;
        }

        public Buffer iWidth(@NativeType(value="EGLint") int value) {
            EGLClientPixmapHI.niWidth(this.address(), value);
            return this;
        }

        public Buffer iHeight(@NativeType(value="EGLint") int value) {
            EGLClientPixmapHI.niHeight(this.address(), value);
            return this;
        }

        public Buffer iStride(@NativeType(value="EGLint") int value) {
            EGLClientPixmapHI.niStride(this.address(), value);
            return this;
        }
    }
}

