/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.searchdemo;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import sunw.demo.searchdemo.Word;

public class WordInventory {
    protected short docId;
    protected short count;
    protected short weight;
    protected Vector wordPos;
    protected Word word;

    public WordInventory(short s, short s2, short s3, short s4, Word word) {
        this.docId = s;
        this.count = s2;
        this.weight = s3;
        this.wordPos = new Vector();
        this.wordPos.addElement(new Short(s4));
        this.word = word;
    }

    public WordInventory(short s, Word word) {
        this.docId = s;
        this.wordPos = new Vector();
        Vector vector = word.getWordInventory();
        for (int i = 0; i < vector.size(); ++i) {
            WordInventory wordInventory = (WordInventory)vector.elementAt(i);
            if (wordInventory.getDocId() != -1) continue;
            this.count = (short)(this.count + wordInventory.count);
            this.weight = (short)(this.weight + wordInventory.weight);
            Vector vector2 = wordInventory.wordPos;
            for (int j = 0; j < wordInventory.wordPos.size(); ++j) {
                this.wordPos.addElement(new Short((Short)vector2.elementAt(j)));
            }
        }
    }

    public WordInventory(DataInputStream dataInputStream, Word word) throws IOException {
        this.docId = dataInputStream.readShort();
        this.count = dataInputStream.readShort();
        this.weight = dataInputStream.readShort();
        int n = dataInputStream.readShort();
        this.wordPos = new Vector(n);
        for (int i = 0; i < n; ++i) {
            this.wordPos.addElement(new Short(dataInputStream.readShort()));
        }
        this.word = word;
    }

    public void writeWordInventory(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.docId);
        dataOutputStream.writeShort(this.count);
        dataOutputStream.writeShort(this.weight);
        int n = this.wordPos.size();
        dataOutputStream.writeShort(n);
        for (int i = 0; i < n; ++i) {
            dataOutputStream.writeShort(((Short)this.wordPos.elementAt(i)).shortValue());
        }
    }

    public void updateInventory(short s, short s2, short s3) {
        this.count = (short)(this.count + s);
        this.weight = (short)(this.weight + s2);
        this.wordPos.addElement(new Short(s3));
    }

    public short getDocId() {
        return this.docId;
    }

    public void setDocId(short s) {
        this.docId = s;
    }

    public short getWeight() {
        return this.weight;
    }

    public String toString() {
        String string = new String("  Inventory: docId=" + this.docId + " count=" + this.count + " weight=" + this.weight + " wordpos=");
        for (int i = 0; i < this.wordPos.size(); ++i) {
            string = string.concat((Short)this.wordPos.elementAt(i) + ",");
        }
        return string;
    }
}

