/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import java.math.BigDecimal;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.CssVersion;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssUnitsCSS3;
import org.w3c.css.values.CssValue;

public class CssResolution
extends CssValue {
    public static final int type = 10;
    private BigDecimal value;
    protected String unit;
    private boolean isInt = false;

    @Override
    public final int getType() {
        return 10;
    }

    private void setValue(String s) {
        this.value = new BigDecimal(s);
        try {
            this.value.toBigIntegerExact();
            this.isInt = true;
        }
        catch (ArithmeticException e) {
            this.isInt = false;
        }
    }

    @Override
    public void set(String s, ApplContext ac) throws InvalidParamException {
        String low_s = s.toLowerCase();
        int length = low_s.length();
        int unitIdx = length - 1;
        char c = low_s.charAt(unitIdx);
        while (unitIdx > 0 && c <= 'z' && c >= 'a') {
            c = low_s.charAt(--unitIdx);
        }
        if (unitIdx == length - 1) {
            throw new InvalidParamException("unit", s, ac);
        }
        String unit_str = low_s.substring(++unitIdx, length);
        switch (ac.getCssVersion()) {
            case CSS3: {
                CssUnitsCSS3.parseResolutionUnit(unit_str, this, ac);
                break;
            }
            default: {
                throw new InvalidParamException("unit", s, ac);
            }
        }
        try {
            String num_s = low_s.substring(0, unitIdx);
            if (ac.getCssVersion().compareTo(CssVersion.CSS3) < 0 && (num_s.indexOf(101) >= 0 || num_s.indexOf(69) >= 0)) {
                throw new InvalidParamException("invalid-number", s, ac);
            }
            this.setValue(num_s);
        }
        catch (NumberFormatException nex) {
            throw new InvalidParamException("invalid-number", low_s.substring(0, unitIdx), ac);
        }
    }

    @Override
    public Object get() {
        if (this.isInt) {
            return this.value.intValue();
        }
        return this.value;
    }

    public float getFloatValue() {
        return this.value.floatValue();
    }

    public String getUnit() {
        return this.unit;
    }

    public String toString() {
        return this.value.toPlainString() + (BigDecimal.ZERO.compareTo(this.value) == 0 ? "dpi" : this.unit);
    }

    @Override
    public boolean equals(Object value) {
        return value instanceof CssResolution && this.value.equals(((CssResolution)value).value) && this.unit.equals(((CssResolution)value).unit);
    }
}

