/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.UpdateSummaryEnum;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.ChangeSetStatus;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.changelog.filter.DbmsChangeSetFilter;
import liquibase.changelog.filter.ShouldRunChangeSetFilter;
import liquibase.changelog.visitor.StatusVisitor;
import liquibase.exception.LiquibaseException;
import liquibase.logging.mdc.MdcObject;
import liquibase.logging.mdc.customobjects.UpdateSummary;
import liquibase.util.StringUtil;
import liquibase.util.TableOutput;

public class ShowSummaryUtil {
    public static void showUpdateSummary(DatabaseChangeLog changeLog, UpdateSummaryEnum showSummary, StatusVisitor statusVisitor, OutputStream outputStream) throws LiquibaseException, IOException {
        if (showSummary == null || showSummary == UpdateSummaryEnum.OFF) {
            return;
        }
        List<ChangeSetStatus> denied = statusVisitor.getChangeSetsToSkip();
        List<ChangeSet> skippedChangeSets = changeLog.getSkippedChangeSets();
        List<ChangeSetStatus> filterDenied = denied.stream().filter(status -> status.getFilterResults().stream().anyMatch(result -> result.getFilter() != ShouldRunChangeSetFilter.class)).collect(Collectors.toList());
        UpdateSummary updateSummaryMdc = ShowSummaryUtil.showSummary(changeLog, statusVisitor, skippedChangeSets, filterDenied, outputStream);
        updateSummaryMdc.setValue(showSummary.toString());
        boolean shouldPrintDetailTable = showSummary != UpdateSummaryEnum.SUMMARY && (!skippedChangeSets.isEmpty() || !denied.isEmpty());
        SortedMap<String, Integer> skippedMdc = ShowSummaryUtil.showDetailTable(skippedChangeSets, filterDenied, outputStream, shouldPrintDetailTable);
        updateSummaryMdc.setSkipped(skippedMdc);
        try (MdcObject updateSummaryMdcObject = Scope.getCurrentScope().addMdcValue("updateSummary", updateSummaryMdc);){
            Scope.getCurrentScope().getLog(ShowSummaryUtil.class).info("Update summary generated");
        }
    }

    private static SortedMap<String, Integer> showDetailTable(List<ChangeSet> skippedChangeSets, List<ChangeSetStatus> filterDenied, OutputStream outputStream, boolean shouldPrintDetailTable) throws IOException, LiquibaseException {
        String totalSkippedMdcKey = "totalSkipped";
        if (filterDenied.isEmpty() && skippedChangeSets.isEmpty()) {
            return new TreeMap<String, Integer>(Collections.singletonMap(totalSkippedMdcKey, 0));
        }
        ArrayList<String> columnHeaders = new ArrayList<String>();
        columnHeaders.add("Changeset Info");
        columnHeaders.add("Reason Skipped");
        ArrayList<List<String>> table = new ArrayList<List<String>>();
        table.add(columnHeaders);
        TreeMap<String, Integer> mdcSkipCounts = new TreeMap<String, Integer>();
        mdcSkipCounts.put(totalSkippedMdcKey, skippedChangeSets.size() + filterDenied.size());
        List<ChangeSetStatus> finalList = ShowSummaryUtil.createFinalStatusList(skippedChangeSets, filterDenied, mdcSkipCounts);
        finalList.sort(new Comparator<ChangeSetStatus>(){

            @Override
            public int compare(ChangeSetStatus o1, ChangeSetStatus o2) {
                ChangeSet c1 = o1.getChangeSet();
                ChangeSet c2 = o2.getChangeSet();
                int order1 = ShowSummaryUtil.determineOrderInChangelog(c1);
                int order2 = ShowSummaryUtil.determineOrderInChangelog(c2);
                return Integer.compare(order1, order2);
            }
        });
        for (ChangeSetStatus st : finalList) {
            AtomicBoolean flag = new AtomicBoolean(true);
            StringBuilder builder = new StringBuilder();
            st.getFilterResults().forEach(consumer -> {
                if (consumer.getFilter() != null) {
                    String displayName = consumer.getMdcName();
                    mdcSkipCounts.merge(displayName, 1, Integer::sum);
                }
                String skippedMessage = String.format("   '%s' : %s", st.getChangeSet().toString(), consumer.getMessage());
                Scope.getCurrentScope().getLog(ShowSummaryUtil.class).info(skippedMessage);
                if (!flag.get()) {
                    builder.append(System.lineSeparator());
                }
                builder.append(consumer.getMessage());
                flag.set(false);
            });
            ArrayList<String> outputRow = new ArrayList<String>();
            outputRow.add(st.getChangeSet().toString());
            outputRow.add(builder.toString());
            table.add(outputRow);
        }
        if (shouldPrintDetailTable) {
            ArrayList<Integer> widths = new ArrayList<Integer>();
            widths.add(60);
            widths.add(40);
            Writer writer = ShowSummaryUtil.createOutputWriter(outputStream);
            TableOutput.formatOutput(table, widths, true, writer);
        }
        return mdcSkipCounts;
    }

    private static List<ChangeSetStatus> createFinalStatusList(List<ChangeSet> skippedChangeSets, List<ChangeSetStatus> filterDenied, SortedMap<String, Integer> mdcSkipCounts) {
        ArrayList<ChangeSetStatus> finalList = new ArrayList<ChangeSetStatus>(filterDenied);
        skippedChangeSets.forEach(skippedChangeSet -> {
            String dbmsList = String.format("'%s'", StringUtil.join(skippedChangeSet.getDbmsSet(), ", "));
            String mismatchMessage = String.format("mismatched DBMS value of %s", dbmsList);
            ChangeSetStatus changeSetStatus = new ChangeSetStatus((ChangeSet)skippedChangeSet);
            ChangeSetFilterResult filterResult = new ChangeSetFilterResult(false, mismatchMessage, DbmsChangeSetFilter.class, "dbmsMismatch", "DBMS mismatch");
            changeSetStatus.setFilterResults(Collections.singleton(filterResult));
            finalList.add(changeSetStatus);
        });
        return finalList;
    }

    private static int determineOrderInChangelog(ChangeSet changeSetToMatch) {
        DatabaseChangeLog changeLog = changeSetToMatch.getChangeLog();
        int order = 0;
        for (ChangeSet changeSet : changeLog.getChangeSets()) {
            if (changeSet == changeSetToMatch) {
                return order;
            }
            ++order;
        }
        return -1;
    }

    private static UpdateSummary showSummary(DatabaseChangeLog changeLog, StatusVisitor statusVisitor, List<ChangeSet> skippedChangeSets, List<ChangeSetStatus> filterDenied, OutputStream outputStream) throws LiquibaseException {
        StringBuilder builder = new StringBuilder();
        builder.append(System.lineSeparator());
        int totalInChangelog = changeLog.getChangeSets().size() + skippedChangeSets.size();
        int skipped = skippedChangeSets.size();
        int filtered = filterDenied.size();
        int totalAccepted = statusVisitor.getChangeSetsToRun().size();
        int totalPreviouslyRun = totalInChangelog - filtered - skipped - totalAccepted;
        UpdateSummary updateSummaryMdc = new UpdateSummary(null, totalAccepted, totalPreviouslyRun, null, totalInChangelog);
        String message = "UPDATE SUMMARY";
        Scope.getCurrentScope().getLog(ShowSummaryUtil.class).info(message);
        builder.append(message);
        builder.append(System.lineSeparator());
        message = String.format("Run:                     %6d", totalAccepted);
        Scope.getCurrentScope().getLog(ShowSummaryUtil.class).info(message);
        builder.append(message);
        builder.append(System.lineSeparator());
        message = String.format("Previously run:          %6d", totalPreviouslyRun);
        Scope.getCurrentScope().getLog(ShowSummaryUtil.class).info(message);
        builder.append(message);
        builder.append(System.lineSeparator());
        message = String.format("Filtered out:            %6d", filtered + skipped);
        Scope.getCurrentScope().getLog(ShowSummaryUtil.class).info(message);
        builder.append(message);
        builder.append(System.lineSeparator());
        message = "-------------------------------";
        Scope.getCurrentScope().getLog(ShowSummaryUtil.class).info(message);
        builder.append(message);
        builder.append(System.lineSeparator());
        message = String.format("Total change sets:       %6d%n", totalInChangelog);
        Scope.getCurrentScope().getLog(ShowSummaryUtil.class).info(message);
        builder.append(message);
        builder.append(System.lineSeparator());
        LinkedHashMap<String, Integer> filterSummaryMap = new LinkedHashMap<String, Integer>();
        List<ChangeSetStatus> finalList = ShowSummaryUtil.createFinalStatusList(skippedChangeSets, filterDenied, null);
        finalList.forEach(status -> status.getFilterResults().forEach(result -> {
            if (!result.isAccepted()) {
                String displayName = result.getDisplayName();
                filterSummaryMap.merge(displayName, 1, Integer::sum);
            }
        }));
        if (!filterSummaryMap.isEmpty()) {
            message = String.format("%nFILTERED CHANGE SETS SUMMARY%n", new Object[0]);
            builder.append(message);
            builder.append(System.lineSeparator());
            Scope.getCurrentScope().getLog(ShowSummaryUtil.class).info(message);
            filterSummaryMap.forEach((filterDisplayName, count) -> {
                String filterSummaryDetailMessage = String.format("%-18s       %6d", filterDisplayName + ":", count);
                Scope.getCurrentScope().getLog(ShowSummaryUtil.class).info(filterSummaryDetailMessage);
                builder.append(filterSummaryDetailMessage);
                builder.append(System.lineSeparator());
            });
            builder.append(System.lineSeparator());
        }
        try {
            Writer writer = ShowSummaryUtil.createOutputWriter(outputStream);
            writer.append(builder.toString());
            writer.flush();
        }
        catch (IOException ioe) {
            throw new LiquibaseException(ioe);
        }
        return updateSummaryMdc;
    }

    private static Writer createOutputWriter(OutputStream outputStream) throws IOException {
        String charsetName = GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue();
        return new OutputStreamWriter(outputStream, charsetName);
    }
}

