/*
 * Decompiled with CFR 0.152.
 */
package tr.view.action.recurrence.modify;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import org.openide.util.NbBundle;
import tr.model.action.Recurrence;
import tr.swing.date.field.DateField;
import tr.view.action.recurrence.PeriodTypeComboBox;

public final class RecurrenceSubsequentPanel
extends JPanel {
    private Recurrence recurrence;
    private ButtonGroup buttonGroup;
    private DateField endDateField;
    private JRadioButton endDateRadio;
    private JLabel endLabel;
    private JRadioButton endNbrRadio;
    private JSpinner endNbrSpinner;
    private JRadioButton endNeverRadio;
    private JLabel createLabel;
    private JSpinner freqSpinner;
    private PeriodTypeComboBox periodCombo;

    public RecurrenceSubsequentPanel() {
        this.initView();
    }

    public void setRecurrence(Recurrence recurrence) {
        this.recurrence = recurrence;
        this.initPanel();
    }

    public void initPanel() {
        this.freqSpinner.setValue(this.recurrence.getFrequency());
        this.periodCombo.setSelectedItem(this.recurrence.getPeriod().getType());
        this.endNbrRadio.setSelected(this.recurrence.getEndNbr() != null);
        this.endNbrSpinner.setValue(this.recurrence.getEndNbr() == null ? 2 : this.recurrence.getEndNbr());
        this.endDateRadio.setSelected(this.recurrence.getEndDate() != null);
        this.endDateField.setDate(this.recurrence.getEndDate());
        this.endNeverRadio.setSelected(!this.endNbrRadio.isSelected() && !this.endDateRadio.isSelected());
    }

    public boolean isValidForm() {
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(RecurrenceSubsequentPanel.class, (String)"change.subsequent.recurrence");
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.freqSpinner.setEnabled(enabled);
        this.periodCombo.setEnabled(enabled);
        this.endNeverRadio.setEnabled(enabled);
        this.endNbrRadio.setEnabled(enabled);
        this.endNbrSpinner.setEnabled(enabled && this.endNbrRadio.isSelected());
        this.endDateRadio.setEnabled(enabled);
        this.endDateField.setEnabled(enabled && this.endDateRadio.isSelected());
    }

    private void initView() {
        this.createLabel = new JLabel(this.getMsg("create.subsequent.action.in"));
        this.periodCombo = new PeriodTypeComboBox();
        this.freqSpinner = new JSpinner();
        this.freqSpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.freqSpinner.setPreferredSize(new Dimension(50, 23));
        this.endLabel = new JLabel(this.getMsg("terminate"));
        this.endNeverRadio = new JRadioButton(this.getMsg("never"));
        this.endNbrRadio = new JRadioButton(this.getMsg("after"));
        this.endNbrSpinner = new JSpinner();
        this.endNbrSpinner.setModel(new SpinnerNumberModel((Number)2, Integer.valueOf(2), null, (Number)1));
        this.endDateRadio = new JRadioButton(this.getMsg("after"));
        this.endDateField = new DateField();
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.endNeverRadio);
        this.buttonGroup.add(this.endNbrRadio);
        this.buttonGroup.add(this.endDateRadio);
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "12[]2[]0", "0[]2[]0"));
        panel.add((Component)this.createLabel, "align left, span, split 3");
        panel.add((Component)this.freqSpinner, "align left");
        panel.add((Component)this.periodCombo, "align left, wrap");
        panel.add((Component)this.endLabel, "align left, span, split 6");
        panel.add((Component)this.endNeverRadio, "align left");
        panel.add((Component)this.endNbrRadio, "align left");
        panel.add((Component)this.endNbrSpinner, "align left, w 54");
        panel.add((Component)this.endDateRadio, "align left");
        panel.add((Component)this.endDateField, "align left, wrap");
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "Center");
    }

    public String getMsg(String key) {
        return NbBundle.getMessage(this.getClass(), (String)key);
    }

    private void initComponents() {
    }
}

