/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Logger;
import org.netbeans.core.output2.AbstractLines;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.OutWriter;
import org.netbeans.core.output2.Storage;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

class FileMapStorage
implements Storage {
    private FileChannel fileChannel;
    private static final int BASE_BUFFER_SIZE = 8196;
    private static final long MAX_MAP_RANGE = 0x100000L;
    private ByteBuffer master;
    private ByteBuffer contents;
    private long mappedRange;
    private long mappedStart;
    private ByteBuffer buffer = null;
    protected int bytesWritten = 0;
    private File outfile = null;
    private int outstandingBufferCount = 0;
    private boolean closed;

    FileMapStorage() {
        this.init();
    }

    private void init() {
        this.contents = null;
        this.mappedRange = -1L;
        this.mappedStart = 0L;
        this.master = ByteBuffer.allocateDirect(8196);
        this.fileChannel = null;
        this.buffer = null;
        this.bytesWritten = 0;
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void ensureFileExists() throws IOException {
        File file;
        if (this.outfile != null) return;
        String string = System.getProperty("java.io.tmpdir");
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        if (!(file = new File(string)).exists() || !file.canWrite()) {
            IllegalStateException illegalStateException = new IllegalStateException("Cannot write to " + string);
            Exceptions.attachLocalizedMessage((Throwable)illegalStateException, (String)NbBundle.getMessage(OutWriter.class, (String)"FMT_CannotWrite", (Object)string));
            throw illegalStateException;
        }
        Class<FileMapStorage> clazz = FileMapStorage.class;
        synchronized (FileMapStorage.class) {
            StringBuilder stringBuilder = new StringBuilder(string).append("output").append(Long.toString(System.currentTimeMillis()));
            this.outfile = new File(stringBuilder.toString());
            while (this.outfile.exists()) {
                stringBuilder.append('x');
                this.outfile = new File(stringBuilder.toString());
            }
            this.outfile.createNewFile();
            this.outfile.deleteOnExit();
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    public String toString() {
        return this.outfile == null ? "[unused or disposed FileMapStorage]" : this.outfile.getPath();
    }

    private FileChannel writeChannel() {
        FileChannel fileChannel = this.fileChannel();
        this.closed = !fileChannel.isOpen();
        return fileChannel;
    }

    private FileChannel fileChannel() {
        try {
            if (this.fileChannel == null || !this.fileChannel.isOpen()) {
                this.ensureFileExists();
                RandomAccessFile randomAccessFile = new RandomAccessFile(this.outfile, "rw");
                this.fileChannel = randomAccessFile.getChannel();
            }
            return this.fileChannel;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    public synchronized ByteBuffer getWriteBuffer(int n) throws IOException {
        int n2;
        if (this.master.capacity() - this.master.position() < n) {
            n2 = Math.max(16392, n + 8196);
            this.master = ByteBuffer.allocateDirect(n2);
        }
        if (this.buffer == null) {
            this.buffer = this.master.slice();
        } else {
            n2 = AbstractLines.toCharIndex(this.buffer.capacity() - this.buffer.position());
            if (n2 < n) {
                this.buffer.flip();
                this.buffer = this.master.slice();
            }
        }
        ++this.outstandingBufferCount;
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer byteBuffer) throws IOException {
        FileMapStorage fileMapStorage = this;
        synchronized (fileMapStorage) {
            if (byteBuffer == this.buffer) {
                this.buffer = null;
            }
        }
        int n = this.size();
        int n2 = byteBuffer.position();
        byteBuffer.flip();
        FileChannel fileChannel = this.writeChannel();
        if (fileChannel.isOpen()) {
            fileChannel.write(byteBuffer);
            FileMapStorage fileMapStorage2 = this;
            synchronized (fileMapStorage2) {
                this.bytesWritten += n2;
                --this.outstandingBufferCount;
            }
        }
        return n;
    }

    public synchronized void dispose() {
        if (Controller.LOG) {
            Controller.log("Disposing file map storage");
            Controller.logStack();
        }
        if (this.fileChannel != null && this.fileChannel.isOpen()) {
            try {
                this.fileChannel.close();
                this.fileChannel = null;
                this.closed = true;
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        if (this.outfile != null && this.outfile.exists()) {
            try {
                this.outfile.delete();
                this.outfile = null;
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        this.buffer = null;
        this.contents = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getReadBuffer(int n, int n2) throws IOException {
        ByteBuffer byteBuffer;
        FileMapStorage fileMapStorage = this;
        synchronized (fileMapStorage) {
            byteBuffer = this.contents;
            if (byteBuffer == null || (long)(n + n2) > this.mappedRange || (long)n < this.mappedStart) {
                FileChannel fileChannel = this.fileChannel();
                this.mappedStart = Math.max(0L, (long)n - 524288L);
                long l = this.mappedRange;
                long l2 = (long)n2 > 524288L ? (long)(n2 + n2 / 10) : 524288L;
                this.mappedRange = Math.min(fileChannel.size(), (long)n + l2);
                try {
                    this.contents = byteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, this.mappedStart, this.mappedRange - this.mappedStart);
                }
                catch (IOException iOException) {
                    Logger.getAnonymousLogger().info("Failed to read output file. Start:" + n + " bytes reqd=" + n2 + " mapped range=" + this.mappedRange + " previous mapped range=" + l + " channel size: " + fileChannel.size());
                    throw iOException;
                }
            }
            if ((long)n - this.mappedStart > (long)(byteBuffer.limit() - n2)) {
                byteBuffer.position(Math.max(0, byteBuffer.limit() - n2));
            } else {
                byteBuffer.position((int)((long)n - this.mappedStart));
            }
        }
        int n3 = Math.min(byteBuffer.limit(), n2);
        try {
            return (ByteBuffer)byteBuffer.slice().limit(n3);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Error setting limit to " + n3 + " contents size = " + byteBuffer.limit() + " requested: read " + "buffer from " + n + " to be " + n2 + " bytes");
        }
    }

    public synchronized int size() {
        return this.bytesWritten;
    }

    public void flush() throws IOException {
        if (this.buffer != null) {
            if (Controller.LOG) {
                Controller.log("FILEMAP STORAGE flush(): " + this.outstandingBufferCount);
            }
            this.write(this.buffer);
            this.fileChannel.force(false);
            this.buffer = null;
        }
    }

    public void close() throws IOException {
        if (this.fileChannel != null) {
            this.flush();
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.fileChannel == null || this.closed;
    }
}

