/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.scilab.forge.jlatexmath.CharFont;
import org.scilab.forge.jlatexmath.FontAlreadyLoadedException;
import org.scilab.forge.jlatexmath.FontInfo;
import org.scilab.forge.jlatexmath.ResourceParseException;
import org.scilab.forge.jlatexmath.SymbolAtom;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.XMLResourceParseException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DefaultTeXFontParser {
    private static boolean a = false;
    private static boolean b = true;
    private static DocumentBuilderFactory a = DocumentBuilderFactory.newInstance();
    protected static ArrayList a = new ArrayList();
    private static Map a;
    private static Map b;
    private Map c;
    private Element a;
    private Object a = null;

    public DefaultTeXFontParser() {
        this(DefaultTeXFontParser.class.getResourceAsStream("DefaultTeXFont.xml"), "DefaultTeXFont.xml");
    }

    public DefaultTeXFontParser(InputStream inputStream, String string) {
        a.setIgnoringElementContentWhitespace(true);
        a.setIgnoringComments(true);
        try {
            this.a = a.newDocumentBuilder().parse(inputStream).getDocumentElement();
        }
        catch (Exception exception) {
            throw new XMLResourceParseException(string, exception);
        }
    }

    public DefaultTeXFontParser(Object object, InputStream inputStream, String string) {
        this.a = object;
        a.setIgnoringElementContentWhitespace(true);
        a.setIgnoringComments(true);
        try {
            this.a = a.newDocumentBuilder().parse(inputStream).getDocumentElement();
        }
        catch (Exception exception) {
            throw new XMLResourceParseException(string, exception);
        }
    }

    private static void setCharChildParsers() {
        b.put("Kern", new KernParser());
        b.put("Lig", new LigParser());
        b.put("NextLarger", new NextLargerParser());
        b.put("Extension", new ExtensionParser());
    }

    public FontInfo[] parseFontDescriptions(FontInfo[] fontInfoArray, InputStream inputStream, String string) {
        int n;
        Element element;
        if (inputStream == null) {
            return fontInfoArray;
        }
        ArrayList<FontInfo> arrayList = new ArrayList<FontInfo>(Arrays.asList(fontInfoArray));
        try {
            element = a.newDocumentBuilder().parse(inputStream).getDocumentElement();
        }
        catch (Exception exception) {
            throw new XMLResourceParseException("Cannot find the file " + string + "!" + exception.toString());
        }
        String string2 = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("name", element);
        String string3 = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("id", element);
        if (a.indexOf(string3) >= 0) {
            throw new FontAlreadyLoadedException("Font " + string3 + " is already loaded !");
        }
        a.add(string3);
        float f = DefaultTeXFontParser.getFloatAndCheck("space", element);
        float f2 = DefaultTeXFontParser.getFloatAndCheck("xHeight", element);
        float f3 = DefaultTeXFontParser.getFloatAndCheck("quad", element);
        int n2 = DefaultTeXFontParser.getOptionalInt("skewChar", element, -1);
        int n3 = DefaultTeXFontParser.getOptionalInt("unicode", element, 0);
        String string4 = null;
        try {
            string4 = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("boldVersion", element);
        }
        catch (ResourceParseException resourceParseException) {
            // empty catch block
        }
        String string5 = null;
        try {
            string5 = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("romanVersion", element);
        }
        catch (ResourceParseException resourceParseException) {
            // empty catch block
        }
        String string6 = null;
        try {
            string6 = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("ssVersion", element);
        }
        catch (ResourceParseException resourceParseException) {
            // empty catch block
        }
        String string7 = null;
        try {
            string7 = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("ttVersion", element);
        }
        catch (ResourceParseException resourceParseException) {
            // empty catch block
        }
        String string8 = null;
        try {
            string8 = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("itVersion", element);
        }
        catch (ResourceParseException resourceParseException) {
            // empty catch block
        }
        String string9 = string.substring(0, string.lastIndexOf("/") + 1) + string2;
        FontInfo fontInfo = new FontInfo(a.indexOf(string3), this.a, string9, string2, n3, f2, f, f3, string4, string5, string6, string7, string8);
        if (n2 != -1) {
            fontInfo.setSkewChar((char)n2);
        }
        NodeList nodeList = element.getElementsByTagName("Char");
        for (n = 0; n < nodeList.getLength(); ++n) {
            DefaultTeXFontParser.processCharElement((Element)nodeList.item(n), fontInfo);
        }
        arrayList.add(fontInfo);
        for (n = 0; n < arrayList.size(); ++n) {
            FontInfo fontInfo2 = arrayList.get(n);
            fontInfo2.setBoldId(a.indexOf(fontInfo2.a));
            fontInfo2.setRomanId(a.indexOf(fontInfo2.b));
            fontInfo2.setSsId(a.indexOf(fontInfo2.c));
            fontInfo2.setTtId(a.indexOf(fontInfo2.d));
            fontInfo2.setItId(a.indexOf(fontInfo2.e));
        }
        this.c = this.parseStyleMappings();
        return arrayList.toArray(fontInfoArray);
    }

    public FontInfo[] parseFontDescriptions(FontInfo[] fontInfoArray) {
        Element element = (Element)this.a.getElementsByTagName("FontDescriptions").item(0);
        if (element != null) {
            NodeList nodeList = element.getElementsByTagName("Metrics");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("include", (Element)nodeList.item(i));
                fontInfoArray = this.a == null ? this.parseFontDescriptions(fontInfoArray, DefaultTeXFontParser.class.getResourceAsStream(string), string) : this.parseFontDescriptions(fontInfoArray, this.a.getClass().getResourceAsStream(string), string);
            }
        }
        return fontInfoArray;
    }

    protected void parseExtraPath() {
        Object object;
        Element element = (Element)this.a.getElementsByTagName("TeXSymbols").item(0);
        if (element != null) {
            object = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("include", element);
            SymbolAtom.addSymbolAtom(this.a.getClass().getResourceAsStream((String)object), (String)object);
        }
        if ((object = (Element)this.a.getElementsByTagName("FormulaSettings").item(0)) != null) {
            String string = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("include", (Element)object);
            TeXFormula.addSymbolMappings(this.a.getClass().getResourceAsStream(string), string);
        }
    }

    private static void processCharElement(Element element, FontInfo fontInfo) {
        char c2 = (char)DefaultTeXFontParser.getIntAndCheck("code", element);
        float[] fArray = new float[]{DefaultTeXFontParser.getOptionalFloat("width", element, 0.0f), DefaultTeXFontParser.getOptionalFloat("height", element, 0.0f), DefaultTeXFontParser.getOptionalFloat("depth", element, 0.0f), DefaultTeXFontParser.getOptionalFloat("italic", element, 0.0f)};
        fontInfo.setMetrics(c2, fArray);
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) continue;
            Element element2 = (Element)node;
            Object v = b.get(element2.getTagName());
            if (v == null) {
                throw new XMLResourceParseException("DefaultTeXFont.xml: a <Char>-element has an unknown child element '" + element2.getTagName() + "'!");
            }
            ((CharChildParser)v).parse(element2, c2, fontInfo);
        }
    }

    public static void registerFonts(boolean bl) {
        b = bl;
    }

    public static Font createFont(String string) {
        return DefaultTeXFontParser.createFont(DefaultTeXFontParser.class.getResourceAsStream(string), string);
    }

    public static Font createFont(InputStream inputStream, String string) {
        try {
            Object object;
            Font font;
            block14: {
                font = Font.createFont(0, inputStream).deriveFont(TeXFormula.a);
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                if (b) {
                    try {
                        object = graphicsEnvironment.getClass().getMethod("registerFont", Font.class);
                        if ((Boolean)((Method)object).invoke((Object)graphicsEnvironment, font) == Boolean.FALSE) {
                            System.err.println("Cannot register the font " + font.getFontName());
                        }
                    }
                    catch (Exception exception) {
                        if (a) break block14;
                        System.err.println("Warning: Jlatexmath: Could not access to registerFont. Please update to java 6");
                        a = true;
                    }
                }
            }
            object = font;
            return object;
        }
        catch (Exception exception) {
            throw new XMLResourceParseException("DefaultTeXFont.xml: error reading font '" + string + "'. Error message: " + exception.getMessage());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("Close threw exception", iOException);
            }
        }
    }

    public Map parseSymbolMappings() {
        HashMap<String, CharFont> hashMap = new HashMap<String, CharFont>();
        Element element = (Element)this.a.getElementsByTagName("SymbolMappings").item(0);
        if (element == null) {
            throw new XMLResourceParseException("DefaultTeXFont.xml", "SymbolMappings");
        }
        NodeList nodeList = element.getElementsByTagName("Mapping");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            String string = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("include", (Element)nodeList.item(i));
            try {
                element2 = this.a == null ? a.newDocumentBuilder().parse(DefaultTeXFontParser.class.getResourceAsStream(string)).getDocumentElement() : a.newDocumentBuilder().parse(this.a.getClass().getResourceAsStream(string)).getDocumentElement();
            }
            catch (Exception exception) {
                throw new XMLResourceParseException("Cannot find the file " + string + "!");
            }
            NodeList nodeList2 = element2.getElementsByTagName("SymbolMapping");
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Element element3 = (Element)nodeList2.item(j);
                String string2 = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("name", element3);
                int n = DefaultTeXFontParser.getIntAndCheck("ch", element3);
                String string3 = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("fontId", element3);
                String string4 = null;
                try {
                    string4 = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("boldId", element3);
                }
                catch (ResourceParseException resourceParseException) {
                    // empty catch block
                }
                if (string4 == null) {
                    hashMap.put(string2, new CharFont((char)n, a.indexOf(string3)));
                    continue;
                }
                hashMap.put(string2, new CharFont((char)n, a.indexOf(string3), a.indexOf(string4)));
            }
        }
        return hashMap;
    }

    public String[] parseDefaultTextStyleMappings() {
        String[] stringArray = new String[4];
        Element element = (Element)this.a.getElementsByTagName("DefaultTextStyleMapping").item(0);
        if (element == null) {
            return stringArray;
        }
        NodeList nodeList = element.getElementsByTagName("MapStyle");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            int n;
            Element element2 = (Element)nodeList.item(i);
            String string = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("code", element2);
            Object v = a.get(string);
            if (v == null) {
                throw new XMLResourceParseException("DefaultTeXFont.xml", "MapStyle", "code", "contains an unknown \"range name\" '" + string + "'!");
            }
            String string2 = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("textStyle", element2);
            Object v2 = this.c.get(string2);
            if (v2 == null) {
                throw new XMLResourceParseException("DefaultTeXFont.xml", "MapStyle", "textStyle", "contains an unknown text style '" + string2 + "'!");
            }
            CharFont[] charFontArray = (CharFont[])this.c.get(string2);
            if (charFontArray[n = ((Integer)v).intValue()] == null) {
                throw new XMLResourceParseException("DefaultTeXFont.xml: the default text style mapping '" + string2 + "' for the range '" + string + "' contains no mapping for that range!");
            }
            stringArray[n] = string2;
        }
        return stringArray;
    }

    public Map parseParameters() {
        HashMap<String, Float> hashMap = new HashMap<String, Float>();
        Element element = (Element)this.a.getElementsByTagName("Parameters").item(0);
        if (element == null) {
            throw new XMLResourceParseException("DefaultTeXFont.xml", "Parameters");
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            String string = ((Attr)namedNodeMap.item(i)).getName();
            hashMap.put(string, new Float(DefaultTeXFontParser.getFloatAndCheck(string, element)));
        }
        return hashMap;
    }

    public Map parseGeneralSettings() {
        HashMap<String, Number> hashMap = new HashMap<String, Number>();
        Element element = (Element)this.a.getElementsByTagName("GeneralSettings").item(0);
        if (element == null) {
            throw new XMLResourceParseException("DefaultTeXFont.xml", "GeneralSettings");
        }
        hashMap.put("mufontid", a.indexOf(DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("mufontid", element)));
        hashMap.put("spacefontid", a.indexOf(DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("spacefontid", element)));
        hashMap.put("scriptfactor", Float.valueOf(DefaultTeXFontParser.getFloatAndCheck("scriptfactor", element)));
        hashMap.put("scriptscriptfactor", Float.valueOf(DefaultTeXFontParser.getFloatAndCheck("scriptscriptfactor", element)));
        return hashMap;
    }

    public Map parseTextStyleMappings() {
        return this.c;
    }

    private Map parseStyleMappings() {
        HashMap<String, CharFont[]> hashMap = new HashMap<String, CharFont[]>();
        Element element = (Element)this.a.getElementsByTagName("TextStyleMappings").item(0);
        if (element == null) {
            return hashMap;
        }
        NodeList nodeList = element.getElementsByTagName("TextStyleMapping");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("name", element2);
            String string2 = null;
            try {
                string2 = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("bold", element2);
            }
            catch (ResourceParseException resourceParseException) {
                // empty catch block
            }
            NodeList nodeList2 = element2.getElementsByTagName("MapRange");
            CharFont[] charFontArray = new CharFont[4];
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Element element3 = (Element)nodeList2.item(j);
                String string3 = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("fontId", element3);
                int n = DefaultTeXFontParser.getIntAndCheck("start", element3);
                String string4 = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("code", element3);
                Object v = a.get(string4);
                if (v == null) {
                    throw new XMLResourceParseException("DefaultTeXFont.xml", "MapRange", "code", "contains an unknown \"range name\" '" + string4 + "'!");
                }
                charFontArray[((Integer)v).intValue()] = string2 == null ? new CharFont((char)n, a.indexOf(string3)) : new CharFont((char)n, a.indexOf(string3), a.indexOf(string2));
            }
            hashMap.put(string, charFontArray);
        }
        return hashMap;
    }

    private static void setRangeTypeMappings() {
        a.put("numbers", 0);
        a.put("capitals", 1);
        a.put("small", 2);
        a.put("unicode", 3);
    }

    private static String getAttrValueAndCheckIfNotNull(String string, Element element) {
        String string2 = element.getAttribute(string);
        if (string2.equals("")) {
            throw new XMLResourceParseException("DefaultTeXFont.xml", element.getTagName(), string, null);
        }
        return string2;
    }

    public static float getFloatAndCheck(String string, Element element) {
        String string2 = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull(string, element);
        float f = 0.0f;
        try {
            f = (float)Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XMLResourceParseException("DefaultTeXFont.xml", element.getTagName(), string, "has an invalid real value!");
        }
        return f;
    }

    public static int getIntAndCheck(String string, Element element) {
        String string2 = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull(string, element);
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XMLResourceParseException("DefaultTeXFont.xml", element.getTagName(), string, "has an invalid integer value!");
        }
        return n;
    }

    public static int getOptionalInt(String string, Element element, int n) {
        String string2 = element.getAttribute(string);
        if (string2.equals("")) {
            return n;
        }
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XMLResourceParseException("DefaultTeXFont.xml", element.getTagName(), string, "has an invalid integer value!");
        }
        return n2;
    }

    public static float getOptionalFloat(String string, Element element, float f) {
        String string2 = element.getAttribute(string);
        if (string2.equals("")) {
            return f;
        }
        float f2 = 0.0f;
        try {
            f2 = (float)Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XMLResourceParseException("DefaultTeXFont.xml", element.getTagName(), string, "has an invalid float value!");
        }
        return f2;
    }

    static {
        a = new HashMap();
        b = new HashMap();
        DefaultTeXFontParser.setRangeTypeMappings();
        DefaultTeXFontParser.setCharChildParsers();
    }

    private static interface CharChildParser {
        public void parse(Element var1, char var2, FontInfo var3);
    }

    private static class ExtensionParser
    implements CharChildParser {
        ExtensionParser() {
        }

        public void parse(Element element, char c2, FontInfo fontInfo) {
            int[] nArray = new int[4];
            nArray[2] = DefaultTeXFontParser.getIntAndCheck("rep", element);
            nArray[0] = DefaultTeXFontParser.getOptionalInt("top", element, -1);
            nArray[1] = DefaultTeXFontParser.getOptionalInt("mid", element, -1);
            nArray[3] = DefaultTeXFontParser.getOptionalInt("bot", element, -1);
            fontInfo.setExtension(c2, nArray);
        }
    }

    private static class KernParser
    implements CharChildParser {
        KernParser() {
        }

        public void parse(Element element, char c2, FontInfo fontInfo) {
            int n = DefaultTeXFontParser.getIntAndCheck("code", element);
            float f = DefaultTeXFontParser.getFloatAndCheck("val", element);
            fontInfo.addKern(c2, (char)n, f);
        }
    }

    private static class LigParser
    implements CharChildParser {
        LigParser() {
        }

        public void parse(Element element, char c2, FontInfo fontInfo) {
            int n = DefaultTeXFontParser.getIntAndCheck("code", element);
            int n2 = DefaultTeXFontParser.getIntAndCheck("ligCode", element);
            fontInfo.addLigature(c2, (char)n, (char)n2);
        }
    }

    private static class NextLargerParser
    implements CharChildParser {
        NextLargerParser() {
        }

        public void parse(Element element, char c2, FontInfo fontInfo) {
            String string = DefaultTeXFontParser.getAttrValueAndCheckIfNotNull("fontId", element);
            int n = DefaultTeXFontParser.getIntAndCheck("code", element);
            fontInfo.setNextLarger(c2, (char)n, a.indexOf(string));
        }
    }
}

