/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssCheckableValue;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.HSL;
import org.w3c.css.values.RGBA;

public class HWB {
    String output = null;
    boolean faSet = false;
    CssValue vh;
    CssValue vw;
    CssValue vb;
    CssValue va;
    static final BigDecimal s100 = new BigDecimal(100);

    public static final CssValue filterValue(ApplContext ac, CssValue val) throws InvalidParamException {
        if (val.getRawType() != 19 && val.getType() == 4) {
            float p;
            CssCheckableValue v = val.getCheckableValue();
            v.checkPositiveness(ac, "RGB");
            if (val.getRawType() == 4 && (double)(p = ((CssPercentage)val).floatValue()) > 100.0) {
                throw new InvalidParamException("range", val, ac);
            }
        }
        return val;
    }

    public final void setHue(ApplContext ac, CssValue val) throws InvalidParamException {
        this.output = null;
        this.vh = HSL.filterHue(ac, val);
    }

    public final void setWhiteness(ApplContext ac, CssValue val) throws InvalidParamException {
        this.output = null;
        this.vw = HWB.filterValue(ac, val);
    }

    public final void setBlackness(ApplContext ac, CssValue val) throws InvalidParamException {
        this.output = null;
        this.vb = HWB.filterValue(ac, val);
    }

    public final void setAlpha(ApplContext ac, CssValue val) throws InvalidParamException {
        this.output = null;
        this.faSet = true;
        this.va = RGBA.filterAlpha(ac, val);
    }

    public void normalize() {
        if (this.vw == null || this.vb == null) {
            return;
        }
        if (this.vw.getRawType() == 4 && this.vb.getRawType() == 4) {
            BigDecimal b;
            CssPercentage pw = (CssPercentage)this.vw;
            CssPercentage pb = (CssPercentage)this.vb;
            BigDecimal w = pw.getValue();
            BigDecimal s = w.add(b = pb.getValue());
            if (s.compareTo(s100) > 0) {
                w = w.multiply(s100).divide(s, 3, RoundingMode.HALF_UP).stripTrailingZeros();
                b = b.multiply(s100).divide(s, 3, RoundingMode.HALF_UP).stripTrailingZeros();
                pw.setValue(w);
                pb.setValue(b);
            }
        }
    }

    public boolean equals(HWB other) {
        if (other != null) {
            return this.vh.equals(other.vh) && this.vw.equals(other.vw) && this.vb.equals(other.vb) && (this.va == null && other.va == null || this.va != null && this.va.equals(other.va));
        }
        return false;
    }

    public String toString() {
        if (this.output == null) {
            this.normalize();
            StringBuilder sb = new StringBuilder("hwb(");
            sb.append(this.vh).append(' ');
            sb.append(this.vw).append(' ');
            sb.append(this.vb);
            if (!this.faSet) {
                sb.append(')');
            } else {
                sb.append(" / ").append(this.va).append(')');
            }
            this.output = sb.toString();
        }
        return this.output;
    }
}

