/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.properties.css3.CssListStyleImage;
import org.w3c.css.properties.css3.CssListStylePosition;
import org.w3c.css.properties.css3.CssListStyleType;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssListStyle
extends org.w3c.css.properties.css.CssListStyle {
    public CssListStyle() {
        this.value = initial;
        this.cssListStyleType = new CssListStyleType();
        this.cssListStylePosition = new CssListStylePosition();
        this.cssListStyleImage = new CssListStyleImage();
    }

    public CssListStyle(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public CssListStyle(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 3) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        CssValue imageVal = null;
        CssValue positionVal = null;
        CssValue typeVal = null;
        int nbnone = 0;
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 2: 
                case 16: {
                    if (imageVal != null) {
                        throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                    }
                    imageVal = val;
                    break;
                }
                case 11: {
                    if (typeVal != null) {
                        throw new InvalidParamException("value", none, this.getPropertyName(), ac);
                    }
                    typeVal = CssListStyleType.parseSymbolsFunction(ac, val, this);
                    break;
                }
                case 1: {
                    if (typeVal != null) {
                        throw new InvalidParamException("value", none, this.getPropertyName(), ac);
                    }
                    typeVal = val;
                    break;
                }
                case 0: {
                    CssIdent id = val.getIdent();
                    if (CssIdent.isCssWide(id)) {
                        if (expression.getCount() > 1) {
                            throw new InvalidParamException("unrecognize", ac);
                        }
                        this.value = val;
                        imageVal = val;
                        positionVal = val;
                        typeVal = val;
                        break;
                    }
                    if (none.equals(id)) {
                        ++nbnone;
                        break;
                    }
                    if (positionVal == null && (positionVal = CssListStylePosition.getAllowedIdent(id)) != null) break;
                    if (typeVal == null) {
                        typeVal = CssListStyleType.getAllowedIdent(id);
                        if (typeVal != null) {
                            typeVal = val;
                            break;
                        }
                        typeVal = val;
                        break;
                    }
                }
                default: {
                    throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                }
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.toString(op), ac);
            }
            expression.next();
        }
        if (nbnone > 0) {
            switch (nbnone) {
                case 1: {
                    if (imageVal != null && typeVal != null) {
                        throw new InvalidParamException("value", none, this.getPropertyName(), ac);
                    }
                    if (typeVal == null) {
                        typeVal = none;
                    }
                    if (imageVal != null) break;
                    imageVal = none;
                    break;
                }
                case 2: {
                    if (imageVal != null || typeVal != null) {
                        throw new InvalidParamException("value", none, this.getPropertyName(), ac);
                    }
                    typeVal = none;
                    imageVal = none;
                    break;
                }
                default: {
                    throw new InvalidParamException("value", none, this.getPropertyName(), ac);
                }
            }
        }
        if (nbnone != 0 || imageVal != null || typeVal != null || positionVal != null) {
            ArrayList<CssValue> v = new ArrayList<CssValue>();
            if (typeVal != null) {
                v.add(typeVal);
            }
            if (positionVal != null) {
                v.add(positionVal);
            }
            if (imageVal != null && (nbnone != 1 || typeVal != none || imageVal != none)) {
                v.add(imageVal);
            }
            this.value = v.size() == 1 ? (CssValue)v.get(0) : new CssValueList(v);
        }
        this.cssListStyleType = new CssListStyleType();
        this.cssListStyleType.value = typeVal == null ? initial : typeVal;
        this.cssListStylePosition = new CssListStylePosition();
        this.cssListStylePosition.value = positionVal == null ? initial : positionVal;
        this.cssListStyleImage = new CssListStyleImage();
        this.cssListStyleImage.value = imageVal == null ? initial : imageVal;
    }
}

