/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.css3.CssColor;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssFunction;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssFilter
extends org.w3c.css.properties.css.CssFilter {
    static final String blur = "blur";
    static final String brightness = "brightness";
    static final String contrast = "contrast";
    static final String drop_shadow = "drop-shadow";
    static final String grayscale = "grayscale";
    static final String hue_rotate = "hue-rotate";
    static final String invert = "invert";
    static final String opacity = "opacity";
    static final String sepia = "sepia";
    static final String saturate = "saturate";
    public static final CssIdent[] legacy_ie_idents;

    public static CssIdent getLegacyIEIdent(CssIdent ident) {
        for (CssIdent id : legacy_ie_idents) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public CssFilter() {
        this.value = initial;
    }

    public CssFilter(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    private static boolean allowLegacyIEValues(ApplContext ac) {
        return ac.getTreatVendorExtensionsAsWarnings();
    }

    public CssFilter(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        this.setByUser();
        this.value = CssFilter.parseFilter(ac, expression, check2, this.getPropertyName());
    }

    public static CssValue parseFilter(ApplContext ac, CssExpression expression, boolean check2, String caller) throws InvalidParamException {
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        Object value = null;
        boolean singleVal = false;
        while (!expression.end()) {
            CssValue val = expression.getValue();
            switch (val.getType()) {
                case 2: {
                    values.add(val);
                    break;
                }
                case 11: {
                    CssFilter.parseFunctionValues(ac, val, caller);
                    values.add(val);
                    break;
                }
                case 0: {
                    CssIdent ident = val.getIdent();
                    if (CssIdent.isCssWide(ident)) {
                        value = val;
                        singleVal = true;
                        break;
                    }
                    if (none.equals(ident)) {
                        value = val;
                        singleVal = true;
                        break;
                    }
                    if (CssFilter.allowLegacyIEValues(ac) && CssFilter.getLegacyIEIdent(ident) != null) {
                        singleVal = true;
                        ac.getFrame().addWarning("vendor-extension", expression.toStringFromStart());
                        value = val;
                        break;
                    }
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), caller, ac);
                }
            }
            expression.next();
        }
        if (singleVal && values.size() > 1) {
            throw new InvalidParamException("value", value.toString(), caller, ac);
        }
        value = values.size() == 1 ? (CssValue)values.get(0) : new CssValueList(values);
        return value;
    }

    protected static void parseFunctionValues(ApplContext ac, CssValue func, CssProperty caller) throws InvalidParamException {
        CssFilter.parseFunctionValues(ac, func, caller.getPropertyName());
    }

    protected static void parseFunctionValues(ApplContext ac, CssValue func, String caller) throws InvalidParamException {
        String fname;
        CssFunction function = func.getFunction();
        switch (fname = function.getName().toLowerCase()) {
            case "blur": {
                CssFilter.parseOneX(ac, function.getParameters(), 6, caller);
                break;
            }
            case "brightness": 
            case "contrast": 
            case "grayscale": 
            case "invert": 
            case "opacity": 
            case "saturate": 
            case "sepia": {
                CssFilter.parseOneNonNegativeNumPercent(ac, function.getParameters(), caller);
                break;
            }
            case "drop-shadow": {
                CssFilter.parseDropShadowFunction(ac, function.getParameters(), caller);
                break;
            }
            case "hue-rotate": {
                CssFilter.parseOneX(ac, function.getParameters(), 7, caller);
                break;
            }
            default: {
                throw new InvalidParamException("value", func.toString(), caller, ac);
            }
        }
    }

    private static void parseOneX(ApplContext ac, CssExpression expression, int type, String caller) throws InvalidParamException {
        if (expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue val = expression.getValue();
        if (val.getType() == 5 && (type == 6 || type == 7) && val.getNumber().isZero()) {
            expression.next();
            return;
        }
        if (val.getType() != type) {
            throw new InvalidParamException("value", val.toString(), caller, ac);
        }
        expression.next();
    }

    private static void parseOneNonNegativeNumPercent(ApplContext ac, CssExpression expression, String caller) throws InvalidParamException {
        if (expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue val = expression.getValue();
        char op = expression.getOperator();
        switch (val.getType()) {
            case 4: 
            case 5: {
                val.getCheckableValue().checkPositiveness(ac, caller);
                break;
            }
            default: {
                throw new InvalidParamException("value", val.toString(), caller, ac);
            }
        }
        if (op != ' ') {
            throw new InvalidParamException("operator", Character.toString(op), ac);
        }
        expression.next();
    }

    private static void parseDropShadowFunction(ApplContext ac, CssExpression expression, String caller) throws InvalidParamException {
        if (expression.getCount() > 4) {
            throw new InvalidParamException("unrecognize", ac);
        }
        int nb_length = 0;
        boolean got_color = false;
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 5: {
                    val.getCheckableValue().checkEqualsZero(ac, caller);
                }
                case 6: {
                    if (got_color || nb_length == 3) {
                        throw new InvalidParamException("value", val.toString(), drop_shadow, ac);
                    }
                    ++nb_length;
                    expression.next();
                    break;
                }
                default: {
                    if (nb_length < 2) {
                        throw new InvalidParamException("value", val.toString(), drop_shadow, ac);
                    }
                    try {
                        CssColor tcolor = new CssColor(ac, expression, false);
                        got_color = true;
                        break;
                    }
                    catch (Exception e) {
                        throw new InvalidParamException("value", val.toString(), drop_shadow, ac);
                    }
                }
            }
            if (op == ' ') continue;
            throw new InvalidParamException("operator", Character.toString(op), ac);
        }
    }

    static {
        String[] _allowed_values = new String[]{"gray", "fliph", "flipv", "xray"};
        legacy_ie_idents = new CssIdent[_allowed_values.length];
        int i = 0;
        for (String s : _allowed_values) {
            CssFilter.legacy_ie_idents[i++] = CssIdent.getIdent(s);
        }
    }
}

