/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.model.WifiAccessPoint;
import org.traccar.session.DeviceSession;

public class MictrackProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN_LOW_ALTITUDE = new PatternBuilder().number("(dd)(dd)(dd).d+,").expression("([AV]),").number("(d+)(dd.d+),").expression("([NS]),").number("(d+)(dd.d+),").expression("([EW]),").number("(d+.?d*)?,").number("(d+.?d*)?,").number("(-?d+.?d*)?,").number("(dd)(dd)(dd)").compile();

    public MictrackProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private Date decodeTime(String data) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMddHHmmss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.parse(data);
    }

    private String decodeAlarm(int event) {
        return switch (event) {
            case 0 -> "powerOn";
            case 5 -> "sos";
            case 8 -> "lowBattery";
            case 9 -> "geofenceEnter";
            case 10 -> "geofenceExit";
            case 12 -> "powerOff";
            default -> null;
        };
    }

    private void decodeLocation(Position position, String data) throws ParseException {
        int index = 0;
        String[] values = data.split("\\+");
        position.set("sat", Integer.parseInt(values[index++]));
        position.setValid(true);
        position.setTime(this.decodeTime(values[index++]));
        position.setLatitude(Double.parseDouble(values[index++]));
        position.setLongitude(Double.parseDouble(values[index++]));
        position.setSpeed(UnitsConverter.knotsFromKph(Double.parseDouble(values[index++])));
        position.setCourse(Integer.parseInt(values[index++]));
        int event = Integer.parseInt(values[index++]);
        position.set("alarm", this.decodeAlarm(event));
        position.set("event", event);
        position.set("battery", (double)Integer.parseInt(values[index++]) * 0.001);
    }

    private void decodeCell(Network network, String data) {
        String[] values = data.split(",");
        int length = values.length % 5 == 0 ? 5 : 4;
        for (int i = 0; i < values.length / length; ++i) {
            int mnc = Integer.parseInt(values[i * length]);
            int cid = Integer.parseInt(values[i * length + 1]);
            int lac = Integer.parseInt(values[i * length + 2]);
            int mcc = Integer.parseInt(values[i * length + 3]);
            network.addCellTower(CellTower.from(mcc, mnc, lac, cid));
        }
    }

    private void decodeWifi(Network network, String data, boolean hasSsid) {
        String[] values = data.split(",");
        int step = hasSsid ? 3 : 2;
        int offset = hasSsid ? 1 : 0;
        for (int i = 0; i < values.length / step; ++i) {
            network.addWifiAccessPoint(WifiAccessPoint.from(values[i * step + offset], Integer.parseInt(values[i * step + offset + 1])));
        }
    }

    private void decodeNetwork(Position position, String data, boolean hasWifi, boolean hasSsid, boolean hasCell) throws ParseException {
        int index = 0;
        String[] values = data.split("\\+");
        this.getLastLocation(position, this.decodeTime(values[index++]));
        Network network = new Network();
        if (hasWifi) {
            this.decodeWifi(network, values[index++], hasSsid);
        }
        if (hasCell) {
            this.decodeCell(network, values[index++]);
        }
        position.setNetwork(network);
        int event = Integer.parseInt(values[index++]);
        position.set("alarm", this.decodeAlarm(event));
        position.set("event", event);
        position.set("battery", (double)Integer.parseInt(values[index++]) * 0.001);
    }

    private void decodeStatus(Position position, String data) throws ParseException {
        int index = 0;
        String[] values = data.split("\\+");
        position.set("sat", Integer.parseInt(values[index++]));
        this.getLastLocation(position, this.decodeTime(values[index++]));
        index += 4;
        int event = Integer.parseInt(values[index++]);
        position.set("alarm", this.decodeAlarm(event));
        position.set("event", event);
        position.set("battery", (double)Integer.parseInt(values[index++]) * 0.001);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = ((String)msg).trim();
        if (sentence.startsWith("MT")) {
            return this.decodeStandard(channel, remoteAddress, sentence);
        }
        if (sentence.contains("$")) {
            return this.decodeLowAltitude(channel, remoteAddress, sentence);
        }
        return this.decodeResult(channel, remoteAddress, sentence);
    }

    private Object decodeResult(Channel channel, SocketAddress remoteAddress, String sentence) {
        if (sentence.matches("\\d{15} .+")) {
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, sentence.substring(0, 15));
            if (deviceSession == null) {
                return null;
            }
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            this.getLastLocation(position, null);
            position.set("result", sentence.substring(16, sentence.length() - 1));
            return position;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, null);
        position.set("result", sentence.substring(0, sentence.length() - 1));
        return position;
    }

    private Object decodeStandard(Channel channel, SocketAddress remoteAddress, String sentence) throws Exception {
        String[] fragments = sentence.split(";");
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, fragments[2]);
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("type", Integer.parseInt(fragments[1]));
        switch (fragments[3]) {
            case "R0": {
                this.decodeLocation(position, fragments[4]);
                break;
            }
            case "R1": {
                this.decodeNetwork(position, fragments[4], true, false, false);
                break;
            }
            case "R2": 
            case "R3": {
                this.decodeNetwork(position, fragments[4], false, false, true);
                break;
            }
            case "R12": 
            case "R13": {
                this.decodeNetwork(position, fragments[4], true, false, true);
                break;
            }
            case "RH": {
                this.decodeStatus(position, fragments[4]);
                break;
            }
            case "Y1": {
                this.decodeNetwork(position, fragments[4], true, true, false);
                break;
            }
            default: {
                return null;
            }
        }
        return position;
    }

    private Object decodeLowAltitude(Channel channel, SocketAddress remoteAddress, String sentence) {
        int separator = sentence.indexOf("$");
        if (separator < 0) {
            return null;
        }
        String deviceId = sentence.substring(0, separator);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, deviceId);
        if (deviceSession == null) {
            return null;
        }
        String[] fragments = sentence.substring(sentence.indexOf("$")).split("\\$");
        LinkedList<Position> positions = new LinkedList<Position>();
        for (String message : fragments) {
            Parser parser = new Parser(PATTERN_LOW_ALTITUDE, message);
            if (!parser.matches()) continue;
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(), parser.nextInt(), parser.nextInt());
            position.setValid(parser.next().equals("A"));
            position.setLatitude(parser.nextCoordinate());
            position.setLongitude(parser.nextCoordinate());
            position.setSpeed(parser.nextDouble(0.0));
            position.setCourse(parser.nextDouble(0.0));
            position.setAltitude(parser.nextDouble(0.0));
            dateBuilder.setDateReverse(parser.nextInt(), parser.nextInt(), parser.nextInt());
            position.setTime(dateBuilder.getDate());
            positions.add(position);
        }
        return positions;
    }
}

