/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class IdplProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("*ID").number("(d+),").number("(d+),").number("(dd)(dd)(dd),").number("(dd)(dd)(dd),").expression("([A|V]),").number("(dd)(dd).?(d+),([NS]),").number("(ddd)(dd).?(d+),([EW]),").number("(d{1,3}.dd),").number("(d{1,3}.dd),").number("(d{1,2}),").number("(d{1,3}),").expression("([A|N|S]),").expression("([0|1]),").number("(d.dd),").expression("([0|1]),").expression("([0|1]),").expression("([0|1])([0|1]),").expression("([0|1|2]),").number("(d{1,3}),").number("(d{1,3}),").expression("([0-9A-Z]{3}),").expression("([L|R]),").number("(x{4})#").compile();

    public IdplProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.set("type", parser.nextInt(0));
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        position.setValid(parser.next().equals("A"));
        position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_MIN_MIN_HEM));
        position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_MIN_MIN_HEM));
        position.setSpeed(parser.nextDouble(0.0));
        position.setCourse(parser.nextDouble(0.0));
        position.set("sat", parser.nextInt(0));
        position.set("rssi", parser.nextInt(0));
        position.set("vehicleStatus", parser.next());
        position.set("power", parser.nextInt(0));
        position.set("battery", parser.nextDouble(0.0));
        if (parser.nextInt(0) == 1) {
            position.set("alarm", "sos");
        }
        parser.nextInt(0);
        position.set("acStatus", parser.nextInt(0));
        position.set("ignition", parser.nextInt(0) == 1);
        position.set("output", parser.nextInt(0));
        position.set("adc1", parser.nextInt(0));
        position.set("adc2", parser.nextInt(0));
        position.set("versionFw", parser.next());
        position.set("archive", parser.next().equals("R"));
        parser.next();
        return position;
    }
}

