/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.codec.encoder.mqtt5;

import com.hivemq.client.internal.mqtt.codec.encoder.mqtt5.Mqtt5MessageEncoderUtil;
import com.hivemq.client.internal.mqtt.codec.encoder.mqtt5.Mqtt5MessageWithUserPropertiesEncoder;
import com.hivemq.client.internal.mqtt.message.disconnect.MqttDisconnect;
import com.hivemq.client.mqtt.mqtt5.message.Mqtt5MessageType;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5DisconnectReasonCode;
import io.netty.buffer.ByteBuf;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;

@Singleton
public class Mqtt5DisconnectEncoder
extends Mqtt5MessageWithUserPropertiesEncoder.WithReason.WithOmissibleCode<MqttDisconnect, Mqtt5DisconnectReasonCode> {
    private static final int FIXED_HEADER = Mqtt5MessageType.DISCONNECT.getCode() << 4;

    @Inject
    Mqtt5DisconnectEncoder() {
    }

    @Override
    int getFixedHeader() {
        return FIXED_HEADER;
    }

    @Override
    @NotNull
    Mqtt5DisconnectReasonCode getDefaultReasonCode() {
        return MqttDisconnect.DEFAULT_REASON_CODE;
    }

    @Override
    int additionalPropertyLength(@NotNull MqttDisconnect message) {
        return Mqtt5MessageEncoderUtil.intPropertyEncodedLength(message.getRawSessionExpiryInterval(), -1L) + Mqtt5MessageEncoderUtil.nullablePropertyEncodedLength(message.getRawServerReference());
    }

    @Override
    void encodeAdditionalProperties(@NotNull MqttDisconnect message, @NotNull ByteBuf out) {
        Mqtt5MessageEncoderUtil.encodeIntProperty(17, message.getRawSessionExpiryInterval(), -1L, out);
        Mqtt5MessageEncoderUtil.encodeNullableProperty(28, message.getRawServerReference(), out);
    }
}

