/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.core.listener;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchPhaseContext;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchRequestContext;
import org.opensearch.action.search.SearchRequestOperationsListener;
import org.opensearch.action.search.SearchTask;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.tasks.resourcetracker.TaskResourceInfo;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.plugin.insights.core.service.QueryInsightsService;
import org.opensearch.plugin.insights.rules.model.Attribute;
import org.opensearch.plugin.insights.rules.model.MetricType;
import org.opensearch.plugin.insights.rules.model.SearchQueryRecord;
import org.opensearch.plugin.insights.settings.QueryInsightsSettings;

public final class QueryInsightsListener
extends SearchRequestOperationsListener {
    private static final ToXContent.Params FORMAT_PARAMS = new ToXContent.MapParams(Collections.singletonMap("pretty", "false"));
    private static final Logger log = LogManager.getLogger(QueryInsightsListener.class);
    private final QueryInsightsService queryInsightsService;
    private final ClusterService clusterService;

    @Inject
    public QueryInsightsListener(ClusterService clusterService, QueryInsightsService queryInsightsService) {
        this.clusterService = clusterService;
        this.queryInsightsService = queryInsightsService;
        for (MetricType type : MetricType.allMetricTypes()) {
            clusterService.getClusterSettings().addSettingsUpdateConsumer(QueryInsightsSettings.getTopNEnabledSetting(type), v -> this.setEnableTopQueries(type, (boolean)v));
            clusterService.getClusterSettings().addSettingsUpdateConsumer(QueryInsightsSettings.getTopNSizeSetting(type), v -> this.queryInsightsService.setTopNSize(type, (int)v), v -> this.queryInsightsService.validateTopNSize(type, (int)v));
            clusterService.getClusterSettings().addSettingsUpdateConsumer(QueryInsightsSettings.getTopNWindowSizeSetting(type), v -> this.queryInsightsService.setWindowSize(type, (TimeValue)v), v -> this.queryInsightsService.validateWindowSize(type, (TimeValue)v));
            this.setEnableTopQueries(type, (Boolean)clusterService.getClusterSettings().get(QueryInsightsSettings.getTopNEnabledSetting(type)));
            this.queryInsightsService.validateTopNSize(type, (Integer)clusterService.getClusterSettings().get(QueryInsightsSettings.getTopNSizeSetting(type)));
            this.queryInsightsService.setTopNSize(type, (Integer)clusterService.getClusterSettings().get(QueryInsightsSettings.getTopNSizeSetting(type)));
            this.queryInsightsService.validateWindowSize(type, (TimeValue)clusterService.getClusterSettings().get(QueryInsightsSettings.getTopNWindowSizeSetting(type)));
            this.queryInsightsService.setWindowSize(type, (TimeValue)clusterService.getClusterSettings().get(QueryInsightsSettings.getTopNWindowSizeSetting(type)));
        }
    }

    public void setEnableTopQueries(MetricType metricType, boolean isCurrentMetricEnabled) {
        boolean isTopNFeatureCurrentlyDisabled;
        boolean isTopNFeaturePreviouslyDisabled = !this.queryInsightsService.isTopNFeatureEnabled();
        this.queryInsightsService.enableCollection(metricType, isCurrentMetricEnabled);
        boolean bl = isTopNFeatureCurrentlyDisabled = !this.queryInsightsService.isTopNFeatureEnabled();
        if (isTopNFeatureCurrentlyDisabled) {
            super.setEnabled(false);
            if (!isTopNFeaturePreviouslyDisabled) {
                this.queryInsightsService.checkAndStopQueryInsights();
            }
        } else {
            super.setEnabled(true);
            if (isTopNFeaturePreviouslyDisabled) {
                this.queryInsightsService.checkAndRestartQueryInsights();
            }
        }
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }

    public void onPhaseStart(SearchPhaseContext context) {
    }

    public void onPhaseEnd(SearchPhaseContext context, SearchRequestContext searchRequestContext) {
    }

    public void onPhaseFailure(SearchPhaseContext context, Throwable cause) {
    }

    public void onRequestStart(SearchRequestContext searchRequestContext) {
    }

    public void onRequestEnd(SearchPhaseContext context, SearchRequestContext searchRequestContext) {
        this.constructSearchQueryRecord(context, searchRequestContext);
    }

    public void onRequestFailure(SearchPhaseContext context, SearchRequestContext searchRequestContext) {
        this.constructSearchQueryRecord(context, searchRequestContext);
    }

    private boolean shouldCollect(MetricType metricType) {
        return this.queryInsightsService.isSearchQueryMetricsFeatureEnabled() || this.queryInsightsService.isCollectionEnabled(metricType);
    }

    private void constructSearchQueryRecord(SearchPhaseContext context, SearchRequestContext searchRequestContext) {
        SearchTask searchTask = context.getTask();
        List tasksResourceUsages = searchRequestContext.getPhaseResourceUsage();
        tasksResourceUsages.add(new TaskResourceInfo(searchTask.getAction(), searchTask.getId(), searchTask.getParentTaskId().getId(), this.clusterService.localNode().getId(), searchTask.getTotalResourceStats()));
        SearchRequest request = context.getRequest();
        try {
            HashMap<MetricType, Number> measurements = new HashMap<MetricType, Number>();
            if (this.shouldCollect(MetricType.LATENCY)) {
                measurements.put(MetricType.LATENCY, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - searchRequestContext.getAbsoluteStartNanos()));
            }
            if (this.shouldCollect(MetricType.CPU)) {
                measurements.put(MetricType.CPU, tasksResourceUsages.stream().map(a -> a.getTaskResourceUsage().getCpuTimeInNanos()).mapToLong(Long::longValue).sum());
            }
            if (this.shouldCollect(MetricType.MEMORY)) {
                measurements.put(MetricType.MEMORY, tasksResourceUsages.stream().map(a -> a.getTaskResourceUsage().getMemoryInBytes()).mapToLong(Long::longValue).sum());
            }
            HashMap<Attribute, Object> attributes = new HashMap<Attribute, Object>();
            attributes.put(Attribute.SEARCH_TYPE, request.searchType().toString().toLowerCase(Locale.ROOT));
            attributes.put(Attribute.SOURCE, request.source());
            attributes.put(Attribute.TOTAL_SHARDS, context.getNumShards());
            attributes.put(Attribute.INDICES, request.indices());
            attributes.put(Attribute.PHASE_LATENCY_MAP, searchRequestContext.phaseTookMap());
            attributes.put(Attribute.TASK_RESOURCE_USAGES, tasksResourceUsages);
            HashMap<String, String> labels = new HashMap<String, String>();
            String userProvidedLabel = context.getTask().getHeader("X-Opaque-Id");
            if (userProvidedLabel != null) {
                labels.put("X-Opaque-Id", userProvidedLabel);
            }
            attributes.put(Attribute.LABELS, labels);
            SearchQueryRecord record = new SearchQueryRecord(request.getOrCreateAbsoluteStartMillis(), measurements, attributes);
            this.queryInsightsService.addRecord(record);
        }
        catch (Exception e) {
            log.error(String.format(Locale.ROOT, "fail to ingest query insight data, error: %s", e));
        }
    }
}

