/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.workflow;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.core.action.ActionListener;
import org.opensearch.flowframework.common.FlowFrameworkSettings;
import org.opensearch.flowframework.common.WorkflowResources;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.exception.WorkflowStepException;
import org.opensearch.flowframework.indices.FlowFrameworkIndicesHandler;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.flowframework.workflow.AbstractRetryableWorkflowStep;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.ml.client.MachineLearningNodeClient;
import org.opensearch.ml.common.MLTask;
import org.opensearch.ml.common.transport.deploy.MLDeployModelResponse;
import org.opensearch.threadpool.ThreadPool;

public class DeployModelStep
extends AbstractRetryableWorkflowStep {
    private static final Logger logger = LogManager.getLogger(DeployModelStep.class);
    private final MachineLearningNodeClient mlClient;
    public static final String NAME = "deploy_model";

    public DeployModelStep(ThreadPool threadPool, MachineLearningNodeClient mlClient, FlowFrameworkIndicesHandler flowFrameworkIndicesHandler, FlowFrameworkSettings flowFrameworkSettings) {
        super(threadPool, mlClient, flowFrameworkIndicesHandler, flowFrameworkSettings);
        this.mlClient = mlClient;
    }

    @Override
    public PlainActionFuture<WorkflowData> execute(final String currentNodeId, final WorkflowData currentNodeInputs, Map<String, WorkflowData> outputs, Map<String, String> previousNodeInputs, Map<String, String> params) {
        final PlainActionFuture deployModelFuture = PlainActionFuture.newFuture();
        Set<String> requiredKeys = Set.of("model_id");
        Set<String> optionalKeys = Collections.emptySet();
        try {
            Map<String, Object> inputs = ParseUtils.getInputsFromPreviousSteps(requiredKeys, optionalKeys, currentNodeInputs, outputs, previousNodeInputs, params);
            final String modelId = (String)inputs.get("model_id");
            this.mlClient.deploy(modelId, (ActionListener)new ActionListener<MLDeployModelResponse>(){

                public void onResponse(MLDeployModelResponse mlDeployModelResponse) {
                    logger.info("Model deployment state {}", (Object)mlDeployModelResponse.getStatus());
                    String taskId = mlDeployModelResponse.getTaskId();
                    DeployModelStep.this.retryableGetMlTask(currentNodeInputs.getWorkflowId(), currentNodeId, (PlainActionFuture<WorkflowData>)deployModelFuture, taskId, "Deploy model", (ActionListener<MLTask>)ActionListener.wrap(mlTask -> {
                        String resourceName = WorkflowResources.getResourceByWorkflowStep(DeployModelStep.this.getName());
                        String id = DeployModelStep.this.getResourceId((MLTask)mlTask);
                        deployModelFuture.onResponse((Object)new WorkflowData(Map.of(resourceName, id), currentNodeInputs.getWorkflowId(), currentNodeId));
                    }, e -> deployModelFuture.onFailure((Exception)((Object)new FlowFrameworkException("Failed to deploy model", ExceptionsHelper.status((Throwable)e))))));
                }

                public void onFailure(Exception ex) {
                    Exception e = WorkflowStepException.getSafeException(ex);
                    Object errorMessage = e == null ? "Failed to deploy model " + modelId : e.getMessage();
                    logger.error((String)errorMessage, (Throwable)e);
                    deployModelFuture.onFailure((Exception)((Object)new WorkflowStepException((String)errorMessage, ExceptionsHelper.status((Throwable)e))));
                }
            });
        }
        catch (FlowFrameworkException e) {
            deployModelFuture.onFailure((Exception)((Object)e));
        }
        return deployModelFuture;
    }

    @Override
    protected String getResourceId(MLTask response) {
        return response.getModelId();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

