/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.model;

import java.io.IOException;
import java.util.List;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

public class WorkflowStepValidator
implements ToXContentObject {
    private static final String INPUTS_FIELD = "inputs";
    private static final String OUTPUTS_FIELD = "outputs";
    private static final String REQUIRED_PLUGINS = "required_plugins";
    private static final String TIMEOUT = "timeout";
    private List<String> inputs;
    private List<String> outputs;
    private List<String> requiredPlugins;
    private TimeValue timeout;

    public WorkflowStepValidator(List<String> inputs, List<String> outputs, List<String> requiredPlugins, TimeValue timeout) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.requiredPlugins = requiredPlugins;
        this.timeout = timeout;
    }

    public List<String> getInputs() {
        return List.copyOf(this.inputs);
    }

    public List<String> getOutputs() {
        return List.copyOf(this.outputs);
    }

    public List<String> getRequiredPlugins() {
        return List.copyOf(this.requiredPlugins);
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        xContentBuilder.startArray(INPUTS_FIELD);
        for (String input : this.inputs) {
            xContentBuilder.value(input);
        }
        xContentBuilder.endArray();
        xContentBuilder.startArray(OUTPUTS_FIELD);
        for (String output : this.outputs) {
            xContentBuilder.value(output);
        }
        xContentBuilder.endArray();
        xContentBuilder.startArray(REQUIRED_PLUGINS);
        for (String rp : this.requiredPlugins) {
            xContentBuilder.value(rp);
        }
        xContentBuilder.endArray();
        if (this.timeout != null) {
            xContentBuilder.field(TIMEOUT, (Object)this.timeout);
        }
        return xContentBuilder.endObject();
    }
}

