/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.timeseries.constant.CommonMessages;
import org.opensearch.timeseries.transport.SearchConfigInfoRequest;
import org.opensearch.timeseries.transport.SearchConfigInfoResponse;
import org.opensearch.timeseries.util.RestHandlerUtils;
import org.opensearch.transport.TransportService;

public abstract class BaseSearchConfigInfoTransportAction
extends HandledTransportAction<SearchConfigInfoRequest, SearchConfigInfoResponse> {
    private static final Logger LOG = LogManager.getLogger(BaseSearchConfigInfoTransportAction.class);
    private final Client client;

    public BaseSearchConfigInfoTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, String searchConfigActionName) {
        super(searchConfigActionName, transportService, actionFilters, SearchConfigInfoRequest::new);
        this.client = client;
    }

    protected void doExecute(Task task, SearchConfigInfoRequest request, ActionListener<SearchConfigInfoResponse> actionListener) {
        String name = request.getName();
        String rawPath = request.getRawPath();
        final ActionListener listener = RestHandlerUtils.wrapRestActionListener(actionListener, CommonMessages.FAIL_TO_GET_CONFIG_INFO);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            SearchRequest searchRequest = new SearchRequest().indices(new String[]{".opendistro-anomaly-detectors"});
            if (rawPath.endsWith("count")) {
                SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
                searchRequest.source(searchSourceBuilder);
                this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                    public void onResponse(SearchResponse searchResponse) {
                        SearchConfigInfoResponse response = new SearchConfigInfoResponse(searchResponse.getHits().getTotalHits().value, false);
                        listener.onResponse((Object)response);
                    }

                    public void onFailure(Exception e) {
                        if (e.getClass() == IndexNotFoundException.class) {
                            SearchConfigInfoResponse response = new SearchConfigInfoResponse(0L, false);
                            listener.onResponse((Object)response);
                        } else {
                            listener.onFailure(e);
                        }
                    }
                });
            } else {
                TermsQueryBuilder query = QueryBuilders.termsQuery((String)"name.keyword", (String[])new String[]{name});
                SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)query);
                searchRequest.source(searchSourceBuilder);
                this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                    public void onResponse(SearchResponse searchResponse) {
                        boolean nameExists = false;
                        nameExists = searchResponse.getHits().getTotalHits().value > 0L;
                        SearchConfigInfoResponse response = new SearchConfigInfoResponse(0L, nameExists);
                        listener.onResponse((Object)response);
                    }

                    public void onFailure(Exception e) {
                        if (e.getClass() == IndexNotFoundException.class) {
                            SearchConfigInfoResponse response = new SearchConfigInfoResponse(0L, false);
                            listener.onResponse((Object)response);
                        } else {
                            listener.onFailure(e);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
            listener.onFailure(e);
        }
    }
}

