/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.opensearch.action.admin.indices.get.GetIndexRequestBuilder;
import org.opensearch.action.admin.indices.get.GetIndexResponse;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsRequestBuilder;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.opensearch.action.admin.indices.settings.get.GetSettingsRequestBuilder;
import org.opensearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.common.settings.Settings;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.IndexSettings;
import org.opensearch.sql.opensearch.client.OpenSearchClient;
import org.opensearch.sql.opensearch.mapping.IndexMapping;
import org.opensearch.sql.opensearch.request.OpenSearchRequest;
import org.opensearch.sql.opensearch.response.OpenSearchResponse;

public class OpenSearchNodeClient
implements OpenSearchClient {
    public static final Function<String, Predicate<String>> ALL_FIELDS = anyIndex -> anyField -> true;
    private final NodeClient client;

    public OpenSearchNodeClient(NodeClient client) {
        this.client = client;
    }

    @Override
    public boolean exists(String indexName) {
        try {
            IndicesExistsResponse checkExistResponse = (IndicesExistsResponse)this.client.admin().indices().exists(new IndicesExistsRequest(new String[]{indexName})).actionGet();
            return checkExistResponse.isExists();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to check if index [" + indexName + "] exists", e);
        }
    }

    @Override
    public void createIndex(String indexName, Map<String, Object> mappings) {
        try {
            CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexName).mapping(mappings);
            this.client.admin().indices().create(createIndexRequest).actionGet();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create index [" + indexName + "]", e);
        }
    }

    @Override
    public Map<String, IndexMapping> getIndexMappings(String ... indexExpression) {
        try {
            GetMappingsResponse mappingsResponse = (GetMappingsResponse)((GetMappingsRequestBuilder)this.client.admin().indices().prepareGetMappings(indexExpression).setLocal(true)).get();
            return mappingsResponse.mappings().entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, cursor -> new IndexMapping((MappingMetadata)cursor.getValue())));
        }
        catch (IndexNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to read mapping for index pattern [" + String.valueOf(indexExpression) + "]", e);
        }
    }

    @Override
    public Map<String, Integer> getIndexMaxResultWindows(String ... indexExpression) {
        try {
            GetSettingsResponse settingsResponse = (GetSettingsResponse)((GetSettingsRequestBuilder)this.client.admin().indices().prepareGetSettings(indexExpression).setLocal(true)).get();
            ImmutableMap.Builder result = ImmutableMap.builder();
            for (Map.Entry indexToSetting : settingsResponse.getIndexToSettings().entrySet()) {
                Settings settings = (Settings)indexToSetting.getValue();
                result.put((Object)((String)indexToSetting.getKey()), (Object)settings.getAsInt(IndexSettings.MAX_RESULT_WINDOW_SETTING.getKey(), (Integer)IndexSettings.MAX_RESULT_WINDOW_SETTING.getDefault(settings)));
            }
            return result.build();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to read setting for index pattern [" + String.valueOf(indexExpression) + "]", e);
        }
    }

    @Override
    public OpenSearchResponse search(OpenSearchRequest request) {
        return request.search(req -> (SearchResponse)this.client.search(req).actionGet(), req -> (SearchResponse)this.client.searchScroll(req).actionGet());
    }

    @Override
    public List<String> indices() {
        GetIndexResponse indexResponse = (GetIndexResponse)((GetIndexRequestBuilder)this.client.admin().indices().prepareGetIndex().setLocal(true)).get();
        Stream<String> aliasStream = ImmutableList.copyOf(indexResponse.aliases().values()).stream().flatMap(Collection::stream).map(AliasMetadata::alias);
        return Stream.concat(Arrays.stream(indexResponse.getIndices()), aliasStream).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> meta() {
        return ImmutableMap.of((Object)"CLUSTER_NAME", (Object)this.client.settings().get("cluster.name", "opensearch"));
    }

    @Override
    public void cleanup(OpenSearchRequest request) {
        request.clean(scrollId -> {
            try {
                this.client.prepareClearScroll().addScrollId(scrollId).get();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to clean up resources for search request " + String.valueOf(request), e);
            }
        });
    }

    @Override
    public void schedule(Runnable task) {
        task.run();
    }

    @Override
    public NodeClient getNodeClient() {
        return this.client;
    }
}

