/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.filtered;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.BytesRef;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.codec.util.KNNVectorSerializer;
import org.opensearch.knn.index.codec.util.KNNVectorSerializerFactory;
import org.opensearch.knn.index.query.filtered.KNNIterator;

public class FilteredIdsKNNIterator
implements KNNIterator {
    protected final BitSet filterIdsBitSet;
    protected final BitSetIterator bitSetIterator;
    protected final float[] queryVector;
    protected final BinaryDocValues binaryDocValues;
    protected final SpaceType spaceType;
    protected float currentScore = Float.NEGATIVE_INFINITY;
    protected int docId;

    public FilteredIdsKNNIterator(BitSet filterIdsBitSet, float[] queryVector, BinaryDocValues binaryDocValues, SpaceType spaceType) {
        this.filterIdsBitSet = filterIdsBitSet;
        this.bitSetIterator = new BitSetIterator(filterIdsBitSet, (long)filterIdsBitSet.length());
        this.queryVector = queryVector;
        this.binaryDocValues = binaryDocValues;
        this.spaceType = spaceType;
        this.docId = this.bitSetIterator.nextDoc();
    }

    @Override
    public int nextDoc() throws IOException {
        if (this.docId == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        int doc = this.binaryDocValues.advance(this.docId);
        this.currentScore = this.computeScore();
        this.docId = this.bitSetIterator.nextDoc();
        return doc;
    }

    @Override
    public float score() {
        return this.currentScore;
    }

    protected float computeScore() throws IOException {
        BytesRef value = this.binaryDocValues.binaryValue();
        KNNVectorSerializer vectorSerializer = KNNVectorSerializerFactory.getSerializerByBytesRef(value);
        float[] vector = vectorSerializer.byteToFloatArray(value);
        return this.spaceType.getKnnVectorSimilarityFunction().compare(this.queryVector, vector);
    }
}

