/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.mapper;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexableFieldType;
import org.opensearch.Version;
import org.opensearch.common.Explicit;
import org.opensearch.common.settings.Settings;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.mapper.KNNVectorFieldMapper;
import org.opensearch.knn.index.util.IndexHyperParametersUtil;
import org.opensearch.knn.index.util.KNNEngine;

public class LegacyFieldMapper
extends KNNVectorFieldMapper {
    @Generated
    private static final Logger log = LogManager.getLogger(LegacyFieldMapper.class);
    protected String spaceType;
    protected String m;
    protected String efConstruction;

    LegacyFieldMapper(String simpleName, KNNVectorFieldMapper.KNNVectorFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Explicit<Boolean> ignoreMalformed, boolean stored, boolean hasDocValues, String spaceType, String m, String efConstruction, Version indexCreatedVersion) {
        super(simpleName, mappedFieldType, multiFields, copyTo, ignoreMalformed, stored, hasDocValues, indexCreatedVersion);
        this.spaceType = spaceType;
        this.m = m;
        this.efConstruction = efConstruction;
        this.fieldType = new FieldType((IndexableFieldType)KNNVectorFieldMapper.Defaults.FIELD_TYPE);
        this.fieldType.putAttribute("dimension", String.valueOf(this.dimension));
        this.fieldType.putAttribute("spaceType", spaceType);
        this.fieldType.putAttribute("engine", KNNEngine.NMSLIB.getName());
        this.fieldType.putAttribute("M", m);
        this.fieldType.putAttribute("efConstruction", efConstruction);
        this.fieldType.freeze();
    }

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new KNNVectorFieldMapper.Builder(this.simpleName(), this.spaceType, this.m, this.efConstruction, this.indexCreatedVersion).init((FieldMapper)this);
    }

    static String getSpaceType(Settings indexSettings, VectorDataType vectorDataType) {
        String spaceType = indexSettings.get(KNNSettings.INDEX_KNN_SPACE_TYPE.getKey());
        if (spaceType == null) {
            spaceType = VectorDataType.BINARY == vectorDataType ? "hamming" : "l2";
            log.info(String.format("[KNN] The setting \"%s\" was not set for the index. Likely caused by recent version upgrade. Setting the setting to the default value=%s", "space_type", spaceType));
        }
        return spaceType;
    }

    static String getM(Settings indexSettings) {
        String m = indexSettings.get(KNNSettings.INDEX_KNN_ALGO_PARAM_M_SETTING.getKey());
        if (m == null) {
            log.info(String.format("[KNN] The setting \"%s\" was not set for the index. Likely caused by recent version upgrade. Setting the setting to the default value=%s", "M", KNNSettings.INDEX_KNN_DEFAULT_ALGO_PARAM_M));
            return String.valueOf(KNNSettings.INDEX_KNN_DEFAULT_ALGO_PARAM_M);
        }
        return m;
    }

    static String getEfConstruction(Settings indexSettings, Version indexVersion) {
        String efConstruction = indexSettings.get(KNNSettings.INDEX_KNN_ALGO_PARAM_EF_CONSTRUCTION_SETTING.getKey());
        if (efConstruction == null) {
            String defaultEFConstructionValue = String.valueOf(IndexHyperParametersUtil.getHNSWEFConstructionValue(indexVersion));
            log.info(String.format("[KNN] The setting \"%s\" was not set for the index. Likely caused by recent version upgrade. Picking up default value for the index =%s", "efConstruction", defaultEFConstructionValue));
            return defaultEFConstructionValue;
        }
        return efConstruction;
    }
}

