/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.transfer;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.opensearch.knn.index.codec.transfer.VectorTransfer;
import org.opensearch.knn.index.codec.util.KNNVectorSerializer;
import org.opensearch.knn.index.codec.util.KNNVectorSerializerFactory;
import org.opensearch.knn.index.codec.util.SerializationMode;
import org.opensearch.knn.jni.JNICommons;

public class VectorTransferFloat
extends VectorTransfer {
    private List<float[]> vectorList = new ArrayList<float[]>();

    public VectorTransferFloat(long vectorsStreamingMemoryLimit) {
        super(vectorsStreamingMemoryLimit);
    }

    @Override
    public void init(long totalLiveDocs) {
        this.totalLiveDocs = totalLiveDocs;
        this.vectorList.clear();
    }

    @Override
    public void transfer(BytesRef bytesRef) {
        KNNVectorSerializer vectorSerializer = KNNVectorSerializerFactory.getSerializerByBytesRef(bytesRef);
        float[] vector = vectorSerializer.byteToFloatArray(bytesRef);
        this.dimension = vector.length;
        if (this.vectorsPerTransfer == Integer.MIN_VALUE) {
            this.vectorsPerTransfer = this.vectorsStreamingMemoryLimit / ((long)this.dimension * 4L);
            if (this.vectorsPerTransfer == 0L) {
                this.vectorsPerTransfer = 1L;
            }
        }
        this.vectorList.add(vector);
        if ((long)this.vectorList.size() == this.vectorsPerTransfer) {
            this.transfer();
        }
    }

    @Override
    public void close() {
        this.transfer();
    }

    @Override
    public SerializationMode getSerializationMode(BytesRef bytesRef) {
        return KNNVectorSerializerFactory.getSerializerModeFromBytesRef(bytesRef);
    }

    private void transfer() {
        this.vectorAddress = JNICommons.storeVectorData(this.vectorAddress, (float[][])this.vectorList.toArray((T[])new float[0][]), this.totalLiveDocs * (long)this.dimension);
        this.vectorList.clear();
    }
}

