/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.transport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRunnable;
import org.opensearch.action.ActionType;
import org.opensearch.action.StepListener;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.routing.Preference;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.model.Table;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.Operator;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.search.sort.SortBuilders;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.securityanalytics.action.ListIOCsActionRequest;
import org.opensearch.securityanalytics.action.ListIOCsActionResponse;
import org.opensearch.securityanalytics.model.DetailedSTIX2IOCDto;
import org.opensearch.securityanalytics.model.STIX2IOCDto;
import org.opensearch.securityanalytics.model.threatintel.IocFinding;
import org.opensearch.securityanalytics.model.threatintel.IocWithFeeds;
import org.opensearch.securityanalytics.threatIntel.action.GetIocFindingsAction;
import org.opensearch.securityanalytics.threatIntel.action.GetIocFindingsRequest;
import org.opensearch.securityanalytics.threatIntel.action.GetIocFindingsResponse;
import org.opensearch.securityanalytics.threatIntel.common.TIFJobState;
import org.opensearch.securityanalytics.threatIntel.model.DefaultIocStoreConfig;
import org.opensearch.securityanalytics.threatIntel.model.SATIFSourceConfig;
import org.opensearch.securityanalytics.threatIntel.service.DefaultTifSourceConfigLoaderService;
import org.opensearch.securityanalytics.threatIntel.service.SATIFSourceConfigService;
import org.opensearch.securityanalytics.threatIntel.transport.TransportSearchTIFSourceConfigsAction;
import org.opensearch.securityanalytics.transport.SecureTransportAction;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportListIOCsAction
extends HandledTransportAction<ListIOCsActionRequest, ListIOCsActionResponse>
implements SecureTransportAction {
    private static final Logger log = LogManager.getLogger(TransportListIOCsAction.class);
    public static final String STIX2_IOC_NESTED_PATH = "stix2_ioc.";
    private final ClusterService clusterService;
    private final TransportSearchTIFSourceConfigsAction transportSearchTIFSourceConfigsAction;
    private final DefaultTifSourceConfigLoaderService defaultTifSourceConfigLoaderService;
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;
    private final ThreadPool threadPool;
    private final SATIFSourceConfigService saTifSourceConfigService;

    @Inject
    public TransportListIOCsAction(ClusterService clusterService, TransportService transportService, TransportSearchTIFSourceConfigsAction transportSearchTIFSourceConfigsAction, SATIFSourceConfigService saTifSourceConfigService, DefaultTifSourceConfigLoaderService defaultTifSourceConfigLoaderService, Client client, NamedXContentRegistry xContentRegistry, ActionFilters actionFilters) {
        super("cluster:admin/opensearch/securityanalytics/threatintel/iocs/list", transportService, actionFilters, ListIOCsActionRequest::new);
        this.clusterService = clusterService;
        this.transportSearchTIFSourceConfigsAction = transportSearchTIFSourceConfigsAction;
        this.saTifSourceConfigService = saTifSourceConfigService;
        this.defaultTifSourceConfigLoaderService = defaultTifSourceConfigLoaderService;
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.threadPool = this.client.threadPool();
    }

    protected void doExecute(Task task, ListIOCsActionRequest request, ActionListener<ListIOCsActionResponse> listener) {
        AsyncListIOCsAction asyncAction = new AsyncListIOCsAction(task, request, listener);
        asyncAction.start();
    }

    private SearchSourceBuilder getFeedsSearchSourceBuilder(List<String> configIds) {
        if (!configIds.isEmpty()) {
            BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
            for (String configId : configIds) {
                queryBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"_id", (Object)configId));
            }
            return new SearchSourceBuilder().query((QueryBuilder)queryBuilder).size(9999);
        }
        BoolQueryBuilder stateQueryBuilder = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)SATIFSourceConfigService.getStateFieldName(), (Object)TIFJobState.REFRESHING.toString())).should((QueryBuilder)QueryBuilders.matchQuery((String)SATIFSourceConfigService.getStateFieldName(), (Object)TIFJobState.AVAILABLE.toString()));
        return new SearchSourceBuilder().query((QueryBuilder)stateQueryBuilder).size(9999);
    }

    class AsyncListIOCsAction {
        private ListIOCsActionRequest request;
        private ActionListener<ListIOCsActionResponse> listener;
        private final AtomicReference<Object> response;
        private final AtomicBoolean counter = new AtomicBoolean();
        private final Task task;

        AsyncListIOCsAction(Task task, ListIOCsActionRequest request, ActionListener<ListIOCsActionResponse> listener) {
            this.task = task;
            this.request = request;
            this.listener = listener;
            this.response = new AtomicReference();
        }

        void start() {
            StepListener defaultTifConfigsLoadedListener = null;
            try {
                defaultTifConfigsLoadedListener = new StepListener();
                TransportListIOCsAction.this.defaultTifSourceConfigLoaderService.createDefaultTifConfigsIfNotExists((ActionListener<Void>)defaultTifConfigsLoadedListener);
                defaultTifConfigsLoadedListener.whenComplete(r -> this.searchIocs(), e -> this.searchIocs());
            }
            catch (Exception e2) {
                log.error("Failed to load default tif source configs. Moving on to list iocs", (Throwable)e2);
                this.searchIocs();
            }
        }

        private void searchIocs() {
            List<String> configIds = this.request.getFeedIds() == null ? Collections.emptyList() : this.request.getFeedIds();
            TransportListIOCsAction.this.saTifSourceConfigService.searchTIFSourceConfigs(TransportListIOCsAction.this.getFeedsSearchSourceBuilder(configIds), (ActionListener<SearchResponse>)ActionListener.wrap(searchResponse -> {
                ArrayList<String> iocIndices = new ArrayList<String>();
                for (SearchHit hit : searchResponse.getHits().getHits()) {
                    XContentParser xcp = XContentType.JSON.xContent().createParser(TransportListIOCsAction.this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                    SATIFSourceConfig config = SATIFSourceConfig.docParse(xcp, hit.getId(), hit.getVersion());
                    if (!(config.getIocStoreConfig() instanceof DefaultIocStoreConfig)) continue;
                    DefaultIocStoreConfig iocStoreConfig = (DefaultIocStoreConfig)config.getIocStoreConfig();
                    for (DefaultIocStoreConfig.IocToIndexDetails iocToindexDetails : iocStoreConfig.getIocToIndexDetails()) {
                        String writeIndex = iocToindexDetails.getActiveIndex();
                        if (writeIndex == null) continue;
                        iocIndices.add(writeIndex);
                    }
                }
                if (iocIndices.isEmpty()) {
                    log.info("No ioc indices found to query for given threat intel source filtering criteria {}", (Object)String.join((CharSequence)",", configIds));
                    this.listener.onResponse((Object)new ListIOCsActionResponse(0L, Collections.emptyList()));
                    return;
                }
                this.listIocs(iocIndices);
            }, e -> {
                log.error(String.format("Failed to fetch threat intel source configs. Unable to return Iocs", new Object[0]), (Throwable)e);
                this.listener.onFailure(e);
            }));
        }

        private void listIocs(List<String> iocIndices) {
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            BoolQueryBuilder typeQueryBuilder = QueryBuilders.boolQuery();
            if (this.request.getTypes() != null && this.request.getTypes().stream().noneMatch(type -> ListIOCsActionRequest.ALL_TYPES_FILTER.equalsIgnoreCase((String)type))) {
                for (String type2 : this.request.getTypes()) {
                    boolQueryBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"stix2_ioc.type", (Object)type2));
                }
                boolQueryBuilder.must((QueryBuilder)typeQueryBuilder);
            }
            if (this.request.getTable().getSearchString() != null && !this.request.getTable().getSearchString().isEmpty()) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)this.request.getTable().getSearchString()).defaultOperator(Operator.OR).field("stix2_ioc.name").field("stix2_ioc.value").field("stix2_ioc.severity").field("stix2_ioc.created").field("stix2_ioc.modified"));
            }
            SortBuilder sortBuilder = SortBuilders.fieldSort((String)(TransportListIOCsAction.STIX2_IOC_NESTED_PATH + this.request.getTable().getSortString())).order(SortOrder.fromString((String)this.request.getTable().getSortOrder()));
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().version(Boolean.valueOf(true)).seqNoAndPrimaryTerm(Boolean.valueOf(true)).fetchSource(true).query((QueryBuilder)boolQueryBuilder).sort(sortBuilder).size(this.request.getTable().getSize()).from(this.request.getTable().getStartIndex());
            SearchRequest searchRequest = new SearchRequest().indices(iocIndices.toArray(new String[0])).source(searchSourceBuilder).preference(Preference.PRIMARY_FIRST.type());
            TransportListIOCsAction.this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                public void onResponse(final SearchResponse searchResponse) {
                    if (searchResponse.isTimedOut()) {
                        AsyncListIOCsAction.this.onFailures((Exception)new OpenSearchStatusException("Search request timed out", RestStatus.REQUEST_TIMEOUT, new Object[0]));
                    }
                    HashSet iocIds = new HashSet();
                    final ArrayList iocs = new ArrayList();
                    Arrays.stream(searchResponse.getHits().getHits()).forEach(hit -> {
                        try {
                            XContentParser xcp = XContentType.JSON.xContent().createParser(TransportListIOCsAction.this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                            xcp.nextToken();
                            STIX2IOCDto ioc = STIX2IOCDto.parse(xcp, hit.getId(), hit.getVersion());
                            iocIds.add(ioc.getId());
                            iocs.add(ioc);
                        }
                        catch (Exception e) {
                            log.error(() -> new ParameterizedMessage("Failed to parse IOC doc from hit {}", (Object)hit.getId()), (Throwable)e);
                        }
                    });
                    GetIocFindingsRequest getFindingsRequest = new GetIocFindingsRequest(Collections.emptyList(), new ArrayList<String>(iocIds), null, null, new Table("asc", "timestamp", AsyncListIOCsAction.this.request.getTable().getMissing(), 10000, 0, ""));
                    TransportListIOCsAction.this.client.execute((ActionType)GetIocFindingsAction.INSTANCE, (ActionRequest)getFindingsRequest, (ActionListener)new ActionListener<GetIocFindingsResponse>(){

                        public void onResponse(GetIocFindingsResponse getFindingsResponse) {
                            HashMap<String, Integer> iocIdToNumFindings = new HashMap<String, Integer>();
                            for (IocFinding iocFinding : getFindingsResponse.getIocFindings()) {
                                for (IocWithFeeds iocWithFeeds : iocFinding.getFeedIds()) {
                                    iocIdToNumFindings.putIfAbsent(iocWithFeeds.getIocId(), 0);
                                    iocIdToNumFindings.merge(iocWithFeeds.getIocId(), 1, Integer::sum);
                                }
                            }
                            ArrayList<DetailedSTIX2IOCDto> iocDetails = new ArrayList<DetailedSTIX2IOCDto>();
                            iocs.forEach(ioc -> {
                                Integer numFindings = (Integer)iocIdToNumFindings.get(ioc.getId());
                                if (numFindings == null) {
                                    log.debug("Null number of findings found for IOC {}", (Object)ioc.getId());
                                    numFindings = 0;
                                }
                                iocDetails.add(new DetailedSTIX2IOCDto((STIX2IOCDto)ioc, numFindings.intValue()));
                            });
                            AsyncListIOCsAction.this.onOperation(new ListIOCsActionResponse(searchResponse.getHits().getTotalHits().value, iocDetails));
                        }

                        public void onFailure(Exception e) {
                            log.error("Failed to get IOC findings count:", (Throwable)e);
                            AsyncListIOCsAction.this.listener.onFailure((Exception)((Object)SecurityAnalyticsException.wrap(e)));
                        }
                    });
                }

                public void onFailure(Exception e) {
                    if (e instanceof IndexNotFoundException) {
                        AsyncListIOCsAction.this.listener.onResponse((Object)ListIOCsActionResponse.EMPTY_RESPONSE);
                    } else {
                        log.error("Failed to list IOCs.", (Throwable)e);
                        AsyncListIOCsAction.this.listener.onFailure((Exception)((Object)SecurityAnalyticsException.wrap(e)));
                    }
                }
            });
        }

        private void onOperation(ListIOCsActionResponse response) {
            this.response.set((Object)response);
            if (this.counter.compareAndSet(false, true)) {
                this.finishHim(response, null);
            }
        }

        private void onFailures(Exception t) {
            if (this.counter.compareAndSet(false, true)) {
                this.finishHim(null, t);
            }
        }

        private void finishHim(ListIOCsActionResponse response, Exception t) {
            TransportListIOCsAction.this.threadPool.executor("generic").execute((Runnable)ActionRunnable.supply(this.listener, () -> {
                if (t != null) {
                    if (t instanceof OpenSearchStatusException) {
                        throw t;
                    }
                    throw SecurityAnalyticsException.wrap(t);
                }
                return response;
            }));
        }
    }
}

