/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.memory.index;

import java.io.IOException;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.OpenSearchWrapperException;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.client.Client;
import org.opensearch.client.Requests;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.ml.common.conversation.ConversationMeta;
import org.opensearch.ml.common.conversation.ConversationalIndexConstants;
import org.opensearch.ml.common.utils.IndexUtils;
import org.opensearch.search.SearchHit;
import org.opensearch.search.sort.SortOrder;

public class ConversationMetaIndex {
    @Generated
    private static final Logger log = LogManager.getLogger(ConversationMetaIndex.class);
    private Client client;
    private ClusterService clusterService;

    private String getUserStrFromThreadContext() {
        return (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
    }

    public void initConversationMetaIndexIfAbsent(ActionListener<Boolean> listener) {
        block11: {
            if (!this.clusterService.state().metadata().hasIndex(".plugins-ml-memory-meta")) {
                log.debug("No conversational meta index found. Adding it");
                CreateIndexRequest request = Requests.createIndexRequest((String)".plugins-ml-memory-meta").mapping(ConversationalIndexConstants.META_MAPPING, XContentType.JSON).settings(IndexUtils.INDEX_SETTINGS);
                try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
                    ActionListener internalListener = ActionListener.runBefore(listener, () -> threadContext.restore());
                    ActionListener al = ActionListener.wrap(createIndexResponse -> {
                        if (createIndexResponse.equals((Object)new CreateIndexResponse(true, true, ".plugins-ml-memory-meta"))) {
                            log.info("created index [.plugins-ml-memory-meta]");
                            internalListener.onResponse((Object)true);
                        } else {
                            internalListener.onResponse((Object)false);
                        }
                    }, e -> {
                        if (e instanceof ResourceAlreadyExistsException || e instanceof OpenSearchWrapperException && e.getCause() instanceof ResourceAlreadyExistsException) {
                            internalListener.onResponse((Object)true);
                        } else {
                            log.error("failed to create index [.plugins-ml-memory-meta]", (Throwable)e);
                            internalListener.onFailure(e);
                        }
                    });
                    this.client.admin().indices().create(request, al);
                }
                catch (Exception e2) {
                    if (e2 instanceof ResourceAlreadyExistsException || e2 instanceof OpenSearchWrapperException && e2.getCause() instanceof ResourceAlreadyExistsException) {
                        listener.onResponse((Object)true);
                        break block11;
                    }
                    log.error("failed to create index [.plugins-ml-memory-meta]", (Throwable)e2);
                    listener.onFailure(e2);
                }
            } else {
                listener.onResponse((Object)true);
            }
        }
    }

    public void createConversation(String name, String applicationType, ActionListener<String> listener) {
        this.initConversationMetaIndexIfAbsent((ActionListener<Boolean>)ActionListener.wrap(indexExists -> {
            if (indexExists.booleanValue()) {
                String userstr = this.getUserStrFromThreadContext();
                Instant now = Instant.now();
                IndexRequest request = Requests.indexRequest((String)".plugins-ml-memory-meta").source(new Object[]{"create_time", now, "updated_time", now, "name", name, "user", userstr == null ? null : User.parse((String)userstr).getName(), "application_type", applicationType});
                try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
                    ActionListener internalListener = ActionListener.runBefore((ActionListener)listener, () -> threadContext.restore());
                    ActionListener al = ActionListener.wrap(resp -> {
                        if (resp.status() == RestStatus.CREATED) {
                            internalListener.onResponse((Object)resp.getId());
                            log.info("Successfully created the memory with id : {}", (Object)resp.getId());
                        } else {
                            internalListener.onFailure((Exception)new IOException("failed to create memory"));
                        }
                    }, e -> {
                        log.error("Failed to create memory", (Throwable)e);
                        internalListener.onFailure(e);
                    });
                    this.client.index(request, al);
                }
                catch (Exception e2) {
                    log.error("Failed to create memory", (Throwable)e2);
                    listener.onFailure(e2);
                }
            } else {
                listener.onFailure((Exception)new IOException("Failed to add memory due to missing index"));
            }
        }, e -> listener.onFailure(e)));
    }

    public void createConversation(ActionListener<String> listener) {
        this.createConversation("", "", listener);
    }

    public void createConversation(String name, ActionListener<String> listener) {
        this.createConversation(name, "", listener);
    }

    public void getConversations(int from, int maxResults, ActionListener<List<ConversationMeta>> listener) {
        if (!this.clusterService.state().metadata().hasIndex(".plugins-ml-memory-meta")) {
            listener.onResponse(List.of());
            return;
        }
        SearchRequest request = Requests.searchRequest((String[])new String[]{".plugins-ml-memory-meta"});
        String userstr = this.getUserStrFromThreadContext();
        Object queryBuilder = userstr == null ? new MatchAllQueryBuilder() : new TermQueryBuilder("user", User.parse((String)userstr).getName());
        request.source().query((QueryBuilder)queryBuilder);
        request.source().from(from).size(maxResults);
        request.source().sort("updated_time", SortOrder.DESC);
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListener.runBefore(listener, () -> threadContext.restore());
            ActionListener al = ActionListener.wrap(searchResponse -> {
                LinkedList<ConversationMeta> result = new LinkedList<ConversationMeta>();
                for (SearchHit hit : searchResponse.getHits()) {
                    result.add(ConversationMeta.fromSearchHit((SearchHit)hit));
                }
                internalListener.onResponse(result);
                log.info("Successfully retrieved memories");
            }, e -> {
                log.error("Failed to retrieve memories", (Throwable)e);
                internalListener.onFailure(e);
            });
            this.client.admin().indices().refresh(Requests.refreshRequest((String[])new String[]{".plugins-ml-memory-meta"}), ActionListener.wrap(refreshResponse -> this.client.search(request, al), e -> {
                log.error("Failed to retrieve memories during refresh", (Throwable)e);
                internalListener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            log.error("Failed to retrieve memories", (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    public void getConversations(int maxResults, ActionListener<List<ConversationMeta>> listener) {
        this.getConversations(0, maxResults, listener);
    }

    public void deleteConversation(String conversationId, ActionListener<Boolean> listener) {
        if (!this.clusterService.state().metadata().hasIndex(".plugins-ml-memory-meta")) {
            listener.onResponse((Object)true);
            return;
        }
        DeleteRequest delRequest = Requests.deleteRequest((String)".plugins-ml-memory-meta").id(conversationId);
        String userstr = this.getUserStrFromThreadContext();
        String user = User.parse((String)userstr) == null ? "BAD_USER" : User.parse((String)userstr).getName();
        this.checkAccess(conversationId, (ActionListener<Boolean>)ActionListener.wrap(access -> {
            if (access.booleanValue()) {
                try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
                    ActionListener internalListener = ActionListener.runBefore((ActionListener)listener, () -> threadContext.restore());
                    ActionListener al = ActionListener.wrap(deleteResponse -> {
                        if (deleteResponse.getResult() == DocWriteResponse.Result.DELETED) {
                            internalListener.onResponse((Object)true);
                        } else if (deleteResponse.status() == RestStatus.NOT_FOUND) {
                            internalListener.onResponse((Object)true);
                        } else {
                            internalListener.onResponse((Object)false);
                        }
                    }, e -> {
                        log.error("Failure deleting memory with ID" + conversationId, (Throwable)e);
                        internalListener.onFailure(e);
                    });
                    this.client.delete(delRequest, al);
                }
                catch (Exception e2) {
                    log.error("Failed deleting memory with id=" + conversationId, (Throwable)e2);
                    listener.onFailure(e2);
                }
            } else {
                throw new OpenSearchStatusException("User [" + user + "] does not have access to memory " + conversationId, RestStatus.UNAUTHORIZED, new Object[0]);
            }
        }, e -> listener.onFailure(e)));
    }

    public void checkAccess(String conversationId, ActionListener<Boolean> listener) {
        if (!this.clusterService.state().metadata().hasIndex(".plugins-ml-memory-meta")) {
            listener.onResponse((Object)true);
            return;
        }
        String userstr = this.getUserStrFromThreadContext();
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListener.runBefore(listener, () -> threadContext.restore());
            GetRequest getRequest = Requests.getRequest((String)".plugins-ml-memory-meta").id(conversationId);
            ActionListener al = ActionListener.wrap(getResponse -> {
                if (!getResponse.isExists() || !getResponse.getId().equals(conversationId)) {
                    throw new ResourceNotFoundException("Memory [" + conversationId + "] not found", new Object[0]);
                }
                if (userstr == null || User.parse((String)userstr) == null) {
                    internalListener.onResponse((Object)true);
                    return;
                }
                ConversationMeta conversation = ConversationMeta.fromMap((String)conversationId, (Map)getResponse.getSourceAsMap());
                String user = User.parse((String)userstr).getName();
                if (!user.equals(conversation.getUser())) {
                    internalListener.onResponse((Object)false);
                    return;
                }
                internalListener.onResponse((Object)true);
            }, e -> internalListener.onFailure(e));
            this.client.admin().indices().refresh(Requests.refreshRequest((String[])new String[]{".plugins-ml-memory-meta"}), ActionListener.wrap(refreshResponse -> this.client.get(getRequest, al), e -> {
                log.error("Failed to refresh memory index during check access ", (Throwable)e);
                internalListener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            listener.onFailure(e2);
        }
    }

    public void searchConversations(SearchRequest request, ActionListener<SearchResponse> listener) {
        request.indices(new String[]{".plugins-ml-memory-meta"});
        QueryBuilder originalQuery = request.source().query();
        BoolQueryBuilder newQuery = new BoolQueryBuilder();
        newQuery.must(originalQuery);
        String userstr = this.getUserStrFromThreadContext();
        if (userstr != null) {
            String user = User.parse((String)userstr) == null ? "BAD_USER" : User.parse((String)userstr).getName();
            newQuery.must((QueryBuilder)new TermQueryBuilder("user", user));
        }
        request.source().query((QueryBuilder)newQuery);
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListener.runBefore(listener, () -> threadContext.restore());
            this.client.admin().indices().refresh(Requests.refreshRequest((String[])new String[]{".plugins-ml-memory-meta"}), ActionListener.wrap(refreshResponse -> this.client.search(request, internalListener), e -> {
                log.error("Failed to refresh memory index during search memories ", (Throwable)e);
                internalListener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            listener.onFailure(e2);
        }
    }

    public void updateConversation(String conversationId, UpdateRequest updateRequest, ActionListener<UpdateResponse> listener) {
        if (!this.clusterService.state().metadata().hasIndex(".plugins-ml-memory-meta")) {
            listener.onFailure((Exception)new IndexNotFoundException("cannot update memory since the memory index does not exist", ".plugins-ml-memory-meta"));
            return;
        }
        this.checkAccess(conversationId, (ActionListener<Boolean>)ActionListener.wrap(access -> {
            if (!access.booleanValue()) {
                String userstr = (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
                String user = User.parse((String)userstr) == null ? "BAD_USER" : User.parse((String)userstr).getName();
                throw new OpenSearchStatusException("User [" + user + "] does not have access to memory " + conversationId, RestStatus.UNAUTHORIZED, new Object[0]);
            }
            this.innerUpdateConversation(updateRequest, listener);
        }, e -> listener.onFailure(e)));
    }

    private void innerUpdateConversation(UpdateRequest updateRequest, ActionListener<UpdateResponse> listener) {
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListener.runBefore(listener, () -> threadContext.restore());
            this.client.update(updateRequest, internalListener);
        }
        catch (Exception e) {
            log.error("Failed to update Memory. Details {}:", (Throwable)e);
            listener.onFailure(e);
        }
    }

    public void getConversation(String conversationId, ActionListener<ConversationMeta> listener) {
        if (!this.clusterService.state().metadata().hasIndex(".plugins-ml-memory-meta")) {
            listener.onFailure((Exception)new IndexNotFoundException("cannot get memory since the memory index does not exist", ".plugins-ml-memory-meta"));
            return;
        }
        String userstr = this.getUserStrFromThreadContext();
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListener.runBefore(listener, () -> threadContext.restore());
            GetRequest request = Requests.getRequest((String)".plugins-ml-memory-meta").id(conversationId);
            ActionListener al = ActionListener.wrap(getResponse -> {
                String user;
                if (!getResponse.isExists() || !getResponse.getId().equals(conversationId)) {
                    throw new ResourceNotFoundException("Memory [" + conversationId + "] not found", new Object[0]);
                }
                ConversationMeta conversation = ConversationMeta.fromMap((String)conversationId, (Map)getResponse.getSourceAsMap());
                if (userstr == null || User.parse((String)userstr) == null) {
                    internalListener.onResponse((Object)conversation);
                    return;
                }
                String string = user = User.parse((String)userstr) == null ? "BAD_USER" : User.parse((String)userstr).getName();
                if (user.equals(conversation.getUser())) {
                    internalListener.onResponse((Object)conversation);
                    log.info("Successfully get the memory for {}", (Object)conversationId);
                    return;
                }
                internalListener.onFailure((Exception)new OpenSearchStatusException("User [" + user + "] does not have access to memory " + conversationId, RestStatus.UNAUTHORIZED, new Object[0]));
            }, e -> internalListener.onFailure(e));
            this.client.admin().indices().refresh(Requests.refreshRequest((String[])new String[]{".plugins-ml-memory-meta"}), ActionListener.wrap(refreshResponse -> this.client.get(request, al), e -> {
                log.error("Failed to refresh the memory index during get memory ", (Throwable)e);
                internalListener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            listener.onFailure(e2);
        }
    }

    @Generated
    public ConversationMetaIndex(Client client, ClusterService clusterService) {
        this.client = client;
        this.clusterService = clusterService;
    }
}

